/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.mark.IndentationException;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.type.HeadingMark;
import com.atlassian.adf.model.mark.type.ParagraphMark;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Indentation
extends AbstractMark
implements HeadingMark,
ParagraphMark,
PositionMark {
    static final Factory<Indentation> FACTORY = new Factory<Indentation>("indentation", Indentation.class, Indentation::parse);
    private final int level;

    private Indentation(int level) {
        if (level < 1 || level > 6) {
            throw new IndentationException.InvalidLevel(level);
        }
        this.level = level;
    }

    public static Indentation indentation(int level) {
        return new Indentation(level);
    }

    @Override
    public Indentation copy() {
        return this;
    }

    public int level() {
        return this.level;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Indentation && ((Indentation)o).level == this.level;
    }

    public int hashCode() {
        return this.level;
    }

    @Override
    public String elementType() {
        return "indentation";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("level", this.level));
    }

    @Override
    public String toString() {
        return this.elementType() + "[" + this.level + "]";
    }

    private static Indentation parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "indentation");
        int level = ParserSupport.getAttrIntOrThrow(map, "level");
        return Indentation.indentation(level);
    }
}

