/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.type.TableMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.TableRow;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableRowContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.REVIEWED, date="2023-07-26")
public class Table
extends AbstractMarkedContentNode<Table, TableRow, TableMark>
implements DocContent,
LayoutColumnContent,
NonNestableBlockContent {
    static Factory<Table> FACTORY = new Factory<Table>("table", Table.class, Table::parse);
    @Nullable
    private Boolean isNumberColumnEnabled;
    @Nullable
    private Layout layout;
    @Nullable
    private Number width;
    @Nullable
    private String localId;

    private Table() {
    }

    @Override
    public Class<TableMark> markClass() {
        return TableMark.class;
    }

    public static Table table() {
        return new Table();
    }

    public static Table table(TableRow content) {
        return (Table)Table.table().content(content);
    }

    public static Table table(TableRow ... content) {
        return (Table)Table.table().content(content);
    }

    public static Table table(Iterable<? extends TableRow> content) {
        return (Table)Table.table().content(content);
    }

    public static Table table(Stream<? extends TableRow> content) {
        return (Table)Table.table().content(content);
    }

    public static Table table(Layout layout) {
        return Table.table().layout(layout);
    }

    public static Table table(Layout layout, TableRow content) {
        return (Table)Table.table().layout(layout).content(content);
    }

    public static Table table(Layout layout, TableRow ... content) {
        return (Table)Table.table().layout(layout).content(content);
    }

    public static Table table(Layout layout, Iterable<? extends TableRow> content) {
        return (Table)Table.table().layout(layout).content(content);
    }

    public static Table table(Layout layout, Stream<? extends TableRow> content) {
        return (Table)Table.table().layout(layout).content(content);
    }

    public Table tr(TableRowContent content) {
        return (Table)this.content(TableRow.tr(content));
    }

    public Table tr(TableRowContent ... content) {
        return (Table)this.content(TableRow.tr(content));
    }

    public Table tr(Iterable<? extends TableRowContent> content) {
        return (Table)this.content(TableRow.tr(content));
    }

    public Table tr(Stream<? extends TableRowContent> content) {
        return (Table)this.content(TableRow.tr(content));
    }

    public boolean isNumberColumnEnabled() {
        return Boolean.TRUE.equals(this.isNumberColumnEnabled);
    }

    public Table isNumberColumnEnabled(@Nullable Boolean isNumberColumnEnabled) {
        this.isNumberColumnEnabled = isNumberColumnEnabled;
        return this;
    }

    public Table withNumberColumn() {
        return this.isNumberColumnEnabled(true);
    }

    public Table withoutNumberColumn() {
        return this.isNumberColumnEnabled(false);
    }

    public Optional<Layout> layout() {
        return Optional.ofNullable(this.layout);
    }

    public Table layout(@Nullable Layout layout) {
        this.layout = layout;
        return this;
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public Table width(@Nullable Number width) {
        this.width = width;
        return this;
    }

    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Table localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Table copy() {
        return Table.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "table";
    }

    @Override
    protected boolean markedContentNodeEquals(Table other) {
        return this.layout == other.layout && Objects.equals(this.isNumberColumnEnabled, other.isNumberColumnEnabled) && Objects.equals(this.width, other.width) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.isNumberColumnEnabled, this.width, this.localId});
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("layout", (Object)this.layout);
        buf.appendField("isNumberColumnEnabled", this.isNumberColumnEnabled);
        buf.appendField("width", this.width);
        buf.appendField("localId", this.localId);
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        FieldMap attrs = FieldMap.map().addIfPresent("isNumberColumnEnabled", this.isNumberColumnEnabled).addMappedIfPresent("layout", this.layout, Layout::layout).addIfPresent("width", this.width).addIfPresent("localId", this.localId);
        return this.mapWithType().addIf(!attrs.isEmpty(), "attrs", () -> attrs).let(this::addContent).let(this.marks::addToMap);
    }

    private static Table parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "table");
        Table table = (Table)Table.table().parseRequiredContent(map, TableRow.class);
        ParserSupport.getAttr(map, "isNumberColumnEnabled", Boolean.class).ifPresent(table::isNumberColumnEnabled);
        ParserSupport.getAttr(map, "layout", String.class).ifPresent(layout -> table.layout(Layout.PARSER.parse((String)layout)));
        ParserSupport.getAttrNumber(map, "width").ifPresent(table::width);
        ParserSupport.getAttr(map, "localId", String.class).ifPresent(table::localId);
        table.parseMarks(map);
        return table;
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextContentJoinedWith('\n', sb);
    }

    public static enum Layout {
        DEFAULT("default"),
        FULL_WIDTH("full-width"),
        WIDE("wide");

        static final EnumParser<Layout> PARSER;
        private final String layout;

        private Layout(String layout) {
            this.layout = layout;
        }

        public String layout() {
            return this.layout;
        }

        static {
            PARSER = new EnumParser<Layout>(Layout.class, Layout::layout);
        }
    }
}

