/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.util.Char;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

@ReturnValuesAreNonnullByDefault
@Internal
public class DateUtil {
    public static String timestampToIsoFormat(String timestamp) {
        LocalDate localDate = DateUtil.parseDate(timestamp);
        StringBuilder sb = new StringBuilder().append(localDate.getYear()).append('-');
        int month = localDate.getMonthValue();
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month).append('-');
        int day = localDate.getDayOfMonth();
        if (day < 10) {
            sb.append('0');
        }
        return sb.append(day).toString();
    }

    private static LocalDate parseDate(String timestamp) {
        if (DateUtil.isPureNumeric(timestamp)) {
            long millis = Long.parseLong(timestamp);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDate.ofInstant(instant, ZoneOffset.UTC);
        }
        try {
            return ZonedDateTime.parse(timestamp).withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        }
        catch (DateTimeParseException ignore) {
            return LocalDate.parse(timestamp);
        }
    }

    private static boolean isPureNumeric(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Char.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

