/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.mark.Code;
import com.atlassian.adf.model.mark.Em;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.Strike;
import com.atlassian.adf.model.mark.Strong;
import com.atlassian.adf.model.mark.SubSup;
import com.atlassian.adf.model.mark.TextColor;
import com.atlassian.adf.model.mark.Underline;
import com.atlassian.adf.model.mark.type.CodeTextMark;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.mark.unsupported.UnsupportedTextMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Colors;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.awt.Color;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.INCOMPLETE, date="2023-07-26", comment="documentation around marks is unclear and omits the 'annotation' mark")
public class Text
extends AbstractMarkedNode<Text, TextMark>
implements CaptionContent,
InlineContent {
    static Factory<Text> FACTORY = new Factory<Text>("text", Text.class, Text::parse);
    private String text;

    private Text(String text) {
        this.text = this.validateText(Objects.requireNonNull(text, "text"));
    }

    private Text(String text, Stream<? extends TextMark> marks) {
        this(text);
        marks.forEach(this::mark);
    }

    public static Text text(String text) {
        return new Text(text);
    }

    public static Stream<Text> text(String ... text) {
        return Arrays.stream(text).map(Text::text);
    }

    public static Stream<Text> text(Iterable<? extends String> text) {
        return StreamSupport.stream(text.spliterator(), false).map(Text::text);
    }

    public static Stream<Text> text(Stream<? extends String> text) {
        return text.map(Text::text);
    }

    public static Text text(String text, TextMark ... marks) {
        return new Text(text, Arrays.stream(marks));
    }

    public static Text text(String text, Iterable<? extends TextMark> marks) {
        return new Text(text, StreamSupport.stream(marks.spliterator(), false));
    }

    public static Text text(String text, Stream<? extends TextMark> marks) {
        return new Text(text, marks);
    }

    @Override
    public Text copy() {
        return Text.parse(this.toMap());
    }

    public Text set(String text) {
        this.text = this.validateText(text);
        return this;
    }

    public Text append(String text) {
        this.text = this.text + text;
        return this;
    }

    public Text uppercase() {
        return this.set(this.text.toUpperCase(Locale.ROOT));
    }

    public Text lowercase() {
        return this.set(this.text.toLowerCase(Locale.ROOT));
    }

    public String text() {
        return this.text;
    }

    public boolean hasSameMarks(Text other) {
        return this.marks.equals(other.marks);
    }

    @Override
    public Class<TextMark> markClass() {
        return TextMark.class;
    }

    @Override
    public Text mark(TextMark mark) {
        this.marks.add(mark);
        this.applyMarkRestrictions(mark);
        return this;
    }

    private void applyMarkRestrictions(TextMark mark) {
        if (mark instanceof CodeTextMark) {
            if (!(mark instanceof FormattedTextMark)) {
                this.marks.restrictToInstancesOf(CodeTextMark.class, "Already used a code-only mark");
            }
        } else if (mark instanceof FormattedTextMark) {
            this.marks.restrictToInstancesOf(FormattedTextMark.class, "Already used a formatted-text-only mark");
        }
    }

    public boolean markIfAllowed(TextMark mark) {
        if (this.marks.addIfAllowed(mark).isPresent()) {
            return false;
        }
        this.applyMarkRestrictions(mark);
        return true;
    }

    public Text code() {
        return this.mark(Code.code());
    }

    public Text em() {
        return this.mark(Em.em());
    }

    public Text link(String url) {
        return this.mark(Link.link(url));
    }

    public Text link(URL url) {
        return this.mark(Link.link(url));
    }

    public Text strike() {
        return this.mark(Strike.strike());
    }

    public Text strong() {
        return this.mark(Strong.strong());
    }

    public Text sub() {
        return this.mark(SubSup.sub());
    }

    public Text sup() {
        return this.mark(SubSup.sup());
    }

    public Text textColor(String color) {
        return this.mark(TextColor.textColor(color));
    }

    public Text textColor(Color color) {
        return this.mark(TextColor.textColor(color));
    }

    public Text textColor(Colors.Named color) {
        return this.mark(TextColor.textColor(color));
    }

    public Text underline() {
        return this.mark(Underline.underline());
    }

    @Override
    public String elementType() {
        return "text";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("text", this.text).let(this.marks::addToMap);
    }

    @Override
    protected boolean markedNodeEquals(Text other) {
        return this.text.equals(other.text);
    }

    @Override
    protected int markedNodeHashCode() {
        return this.text.hashCode();
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendTextField(this.text);
    }

    @Override
    @Nullable
    protected Factory<TextMark> unsupportedMarkFactory() {
        return UnsupportedTextMark.FACTORY;
    }

    void disableMarks(ContentNode<?, ? super Text> parent) {
        this.marks.disable(parent.elementType());
    }

    private static Text parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "text");
        String text = (String)ParserSupport.getOrThrow(map, "text");
        return (Text)Text.text(text).parseMarks(map);
    }

    protected String validateText(String text) {
        return Element.nonEmpty(text, "text");
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append(this.text);
    }
}

