/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.CardException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CardNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import com.atlassian.annotations.Internal;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractCardNode<C extends AbstractCardNode<C>>
extends AbstractNode<C>
implements CardNode {
    private final CardNode.UrlOrData urlOrData;

    protected AbstractCardNode(CardNode.UrlOrData urlOrData) {
        this.urlOrData = Objects.requireNonNull(urlOrData, "urlOrData");
    }

    public abstract C copy();

    @Override
    protected final boolean nodeEquals(C other) {
        return this.urlOrData.equals(((AbstractCardNode)other).urlOrData());
    }

    @Override
    protected final int nodeHashCode() {
        return this.urlOrData.hashCode();
    }

    @Override
    protected final void appendNodeFields(AbstractNode.ToStringHelper buf) {
        this.urlOrData.accept((Consumer<? super String>)((Consumer<String>)url -> buf.appendField("url", url)), (Consumer<? super Map<String, ?>>)((Consumer<Map>)data -> buf.appendField("data", data)));
    }

    @Override
    public final Map<String, ?> toMap() {
        return FieldMap.map("type", this.elementType(), "attrs", this.urlOrData().fold(url -> FieldMap.map("url", url), data -> FieldMap.map("data", FieldMap.map().addAll((Map<String, ?>)data))));
    }

    protected static CardNode.UrlOrData parseUrlOrData(Map<String, ?> map) {
        String url = ParserSupport.getAttr(map, "url", String.class).orElse(null);
        Map data = (Map)Cast.unsafeCast(ParserSupport.getAttr(map, "data", Map.class).orElse(null));
        if (url != null) {
            if (data != null) {
                throw new CardException.UrlAndDataCannotBothBeSet();
            }
            return new UrlImpl(url);
        }
        if (data == null) {
            throw new CardException.UrlOrDataMustBeSet();
        }
        return new DataImpl(data);
    }

    @Override
    public final CardNode.UrlOrData urlOrData() {
        return this.urlOrData;
    }

    @Override
    public void validate() {
    }

    public static interface Partial {

        public static class NeedsUrlOrData<C extends AbstractCardNode<C>> {
            private final Function<CardNode.UrlOrData, C> constructor;

            public NeedsUrlOrData(Function<CardNode.UrlOrData, C> constructor) {
                this.constructor = constructor;
            }

            public C url(String url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return (C)((AbstractCardNode)this.constructor.apply(new UrlImpl(cleanUrl)));
            }

            public C url(URL url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return (C)((AbstractCardNode)this.constructor.apply(new UrlImpl(cleanUrl)));
            }

            public C url(URI url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return (C)((AbstractCardNode)this.constructor.apply(new UrlImpl(cleanUrl)));
            }

            public C data(Map<String, ?> data) {
                return (C)((AbstractCardNode)this.constructor.apply(new DataImpl(data)));
            }
        }
    }

    private static class DataImpl
    implements CardNode.UrlOrData {
        private final Map<String, ?> data;

        DataImpl(Map<String, ?> data) {
            Objects.requireNonNull(data, "data");
            this.data = new LinkedHashMap(data);
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData) {
            return ifData.apply(this.data);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData) {
            ifData.accept(this.data);
        }

        @Override
        public Optional<String> url() {
            return Optional.empty();
        }

        @Override
        public Optional<Map<String, ?>> data() {
            return Optional.of(this.data);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof DataImpl && ((DataImpl)o).data.equals(this.data);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.data.hashCode();
        }

        public String toString() {
            return "DataImpl{data=" + this.data + "}";
        }
    }

    private static class UrlImpl
    implements CardNode.UrlOrData {
        private final String url;

        private UrlImpl(String url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData) {
            return ifUrl.apply(this.url);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData) {
            ifUrl.accept(this.url);
        }

        @Override
        public Optional<String> url() {
            return Optional.of(this.url);
        }

        @Override
        public Optional<Map<String, ?>> data() {
            return Optional.empty();
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof UrlImpl && ((UrlImpl)o).url.equals(this.url);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.url.hashCode();
        }

        public String toString() {
            return "UrlImpl{url=" + this.url + "}";
        }
    }
}

