/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.mark.BorderException;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.type.MediaMark;
import com.atlassian.adf.util.Char;
import com.atlassian.adf.util.Colors;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Border
extends AbstractMark
implements MediaMark {
    static final Factory<Border> FACTORY = new Factory<Border>("border", Border.class, Border::parse);
    public static final int DEFAULT_SIZE = 2;
    public static final int MINIMUM_SIZE = 1;
    public static final int MAXIMUM_SIZE = 3;
    public static final String DEFAULT_COLOR = "#091E4224";
    private int size;
    private String color;

    private Border(int size, String color) {
        this.size = size;
        this.color = color;
    }

    public static Border border() {
        return new Border(2, DEFAULT_COLOR);
    }

    public static Border border(String color) {
        return new Border(2, Border.validateColor(color));
    }

    public static Border border(Color color) {
        return new Border(2, Colors.hex(color));
    }

    public static Border border(Colors.Named color) {
        return new Border(2, color.toHex());
    }

    public int size() {
        return this.size;
    }

    public Border size(int size) {
        this.size = Border.validateSize(size);
        return this;
    }

    public String color() {
        return this.color;
    }

    public Border color(String color) {
        this.color = Border.validateColor(color);
        return this;
    }

    public Border color(Color color) {
        this.color = Colors.hex(color);
        return this;
    }

    public Border color(Colors.Named color) {
        this.color = color.toHex();
        return this;
    }

    @Override
    public String elementType() {
        return "border";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Border)) {
            return false;
        }
        Border other = (Border)o;
        return this.size == other.size && this.color.equals(other.color);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.color);
    }

    @Override
    public String toString() {
        return this.elementType() + "[size=" + this.size + ", color=" + this.color + "]";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("size", this.size).add("color", this.color));
    }

    private static Border parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "border");
        String color = (String)ParserSupport.getAttrOrThrow(map, "color");
        int size = Border.validateSize(ParserSupport.getAttrIntOrThrow(map, "size"));
        return new Border(size, color);
    }

    private static int validateSize(int size) {
        if (size >= 1 && size <= 3) {
            return size;
        }
        throw new BorderException.InvalidSize(size);
    }

    private static String validateColor(String color) {
        Objects.requireNonNull(color, "color");
        if (Border.isValidColor(color)) {
            return color;
        }
        throw new BorderException.InvalidColor(color);
    }

    private static boolean isValidColor(String color) {
        int len = color.length();
        if (len != 7 && len != 9) {
            return false;
        }
        if (color.charAt(0) != '#') {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Char.isHexit(color.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Border copy() {
        return Border.parse(this.toMap());
    }
}

