/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Schema;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.DocException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

@Documentation(state=Documentation.State.REVIEWED, date="2023-07-26")
public class Doc
extends AbstractContentNode<Doc, DocContent> {
    @Deprecated(forRemoval=true)
    public static final String SCHEMA_VERSION = Schema.version();
    static Factory<Doc> FACTORY = new Factory<Doc>("doc", Doc.class, Doc::parse);
    private static final Version DEFAULT_VERSION = Version.V1;
    private Version version = DEFAULT_VERSION;

    private Doc() {
    }

    public static Doc doc() {
        return new Doc();
    }

    public static Doc doc(DocContent content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(DocContent ... content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Iterable<? extends DocContent> content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Stream<? extends DocContent> content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Version version) {
        return Doc.doc().version(version);
    }

    public static Doc doc(Version version, DocContent content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, DocContent ... content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, Iterable<? extends DocContent> content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, Stream<? extends DocContent> content) {
        return (Doc)Doc.doc(version).content(content);
    }

    @Override
    public Doc copy() {
        return Doc.parse(this.toMap());
    }

    public Doc version(Version version) {
        this.version = Objects.requireNonNull(version, "version");
        return this;
    }

    public Version version() {
        return this.version;
    }

    @Override
    protected boolean contentNodeEquals(Doc other) {
        return this.version == other.version;
    }

    @Override
    protected int contentNodeHashCode() {
        return this.version.hashCode();
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("version", (Object)this.version);
    }

    @Override
    public String elementType() {
        return "doc";
    }

    @Override
    protected void validateContentNodeForAppend(DocContent node) {
        super.validateContentNodeForAppend(node);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("version", this.version.value()).add("content", this.contentFieldMaps());
    }

    public static Doc parse(Map<String, ?> map) {
        return AdfException.frame("doc", () -> {
            String type = ParserSupport.getTypeOrThrow(map);
            if (!"doc".equals(type)) {
                throw new DocException.InvalidTopLevel(type);
            }
            Version version = Version.parse((Number)ParserSupport.getOrThrow(map, "version"));
            return (Doc)Doc.doc(version).parseRequiredContentAllowEmpty(map, DocContent.class);
        });
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        int pos = sb.length();
        this.appendPlainTextContentJoinedWith('\n', sb);
        while (pos < sb.length() && (pos = sb.indexOf("\n\n", pos)) != -1) {
            int stop;
            for (stop = ++pos + 1; stop < sb.length() && sb.charAt(stop) == '\n'; ++stop) {
            }
            sb.delete(pos, stop);
        }
    }

    public static enum Version {
        V1(1);

        private final int value;

        private Version(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        static Version parse(Number version) {
            return Version.parse(ParserSupport.asInt(version, "version"));
        }

        static Version parse(int version) {
            if (version == V1.value()) {
                return V1;
            }
            throw new DocException.UnsupportedVersion(version);
        }
    }
}

