/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.type.HeadingMark;
import com.atlassian.adf.model.mark.type.ParagraphMark;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;

@Immutable
@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Alignment
extends AbstractMark
implements HeadingMark,
ParagraphMark,
PositionMark {
    private static final Alignment CENTER = new Alignment(Align.CENTER);
    private static final Alignment END = new Alignment(Align.END);
    static final Factory<Alignment> FACTORY = new Factory<Alignment>("alignment", Alignment.class, Alignment::parse);
    private final Align align;

    private Alignment(Align align) {
        this.align = Objects.requireNonNull(align, "align");
    }

    @Override
    public Alignment copy() {
        return this;
    }

    public static Alignment center() {
        return CENTER;
    }

    public static Alignment end() {
        return END;
    }

    public static Alignment alignment(String align) {
        return Alignment.alignment(Align.PARSER.parse(align));
    }

    public static Alignment alignment(Align align) {
        return align.toAlignment();
    }

    public Align align() {
        return this.align;
    }

    @Override
    public String elementType() {
        return "alignment";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("align", this.align.align()));
    }

    @Override
    public String toString() {
        return this.elementType() + "[" + this.align + "]";
    }

    private static Alignment parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "alignment");
        return Alignment.alignment(ParserSupport.getAttrOrThrow(map, "align", String.class));
    }

    public static enum Align {
        CENTER("center", Alignment::center),
        END("end", Alignment::end);

        static final EnumParser<Align> PARSER;
        private final String align;
        private final Supplier<Alignment> toAlignment;

        private Align(String align, Supplier<Alignment> toAlignment) {
            this.align = align;
            this.toAlignment = toAlignment;
        }

        public String align() {
            return this.align;
        }

        Alignment toAlignment() {
            return this.toAlignment.get();
        }

        static {
            PARSER = new EnumParser<Align>(Align.class, Align::align);
        }
    }
}

