/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.node.NodeException;
import java.util.Objects;

public abstract class DocException
extends NodeException {
    private static final long serialVersionUID = 1L;

    DocException(String message) {
        super(message);
    }

    public static class UnsupportedVersion
    extends DocException {
        private static final long serialVersionUID = 1L;
        private final Number version;

        public UnsupportedVersion(Number version) {
            super("Unsupported version: " + version);
            this.version = Objects.requireNonNull(version, "version");
        }

        public Number version() {
            return this.version;
        }
    }

    public static class InvalidTopLevel
    extends DocException {
        private static final long serialVersionUID = 1L;
        private final String type;

        public InvalidTopLevel(String type) {
            super("Invalid top-level node: expected 'doc', got '" + type + "'");
            this.type = Objects.requireNonNull(type, "type");
        }

        public String type() {
            return this.type;
        }
    }
}

