/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.node.NodeException;
import java.util.Objects;

public abstract class CardException
extends NodeException {
    private static final long serialVersionUID = 1L;

    CardException(String message) {
        super(message);
    }

    public static class InvalidWidth
    extends CardException {
        private static final long serialVersionUID = 1L;
        private final Number width;

        public InvalidWidth(Number width) {
            super("The 'width' must be from 0.0 to 100.0: " + width);
            this.width = Objects.requireNonNull(width, "width");
        }

        public Number width() {
            return this.width;
        }
    }

    public static class UrlOrDataMustBeSet
    extends CardException {
        private static final long serialVersionUID = 1L;

        public UrlOrDataMustBeSet() {
            super("Either the 'url' or 'data' value must be set");
        }
    }

    public static class UrlAndDataCannotBothBeSet
    extends CardException {
        private static final long serialVersionUID = 1L;

        public UrlAndDataCannotBothBeSet() {
            super("The 'url' and 'data' values cannot both be set");
        }
    }
}

