/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.mark;

import com.atlassian.adf.model.ex.AdfException;

public class BorderException
extends AdfException {
    private static final long serialVersionUID = 1L;

    BorderException(String message) {
        super(message);
    }

    public static class InvalidColor
    extends BorderException {
        private static final long serialVersionUID = 1L;
        private final String color;

        public InvalidColor(String color) {
            super("Invalid color value: '" + color + "'");
            this.color = color;
        }

        public String color() {
            return this.color;
        }
    }

    public static class InvalidSize
    extends BorderException {
        private static final long serialVersionUID = 1L;
        private final int size;

        public InvalidSize(int size) {
            super("The border size must be within the range [1, 3]: " + size);
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

