package com.atlassian.adf.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import java.util.function.Consumer;
import java.util.function.Function;

import static com.atlassian.adf.util.Functions.voidFn;

/**
 * Sum type of three other types.
 */
@PublicApi
@ReturnValuesAreNonnullByDefault
public interface Fold3<A, B, C> {
    <T> T fold(
            Function<? super A, ? extends T> ifA,
            Function<? super B, ? extends T> ifB,
            Function<? super C, ? extends T> ifC
    );

    default void accept(
            Consumer<? super A> ifA,
            Consumer<? super B> ifB,
            Consumer<? super C> ifC
    ) {
        fold(voidFn(ifA), voidFn(ifB), voidFn(ifC));
    }
}
