/**
 * <strong>{@link com.atlassian.adf.model QUICK START GUIDE}</strong>.
 * <h1>Quick Start Guide</h1>
 * What do you want to do?
 * <ul>
 *     <li>{@link com.atlassian.adf.model.node.Doc Build brand new ADF content}</li>
 *     <li>{@link com.atlassian.adf.model.node.Doc#parse(java.util.Map) Parse existing ADF content}</li>
 *     <li>{@link com.atlassian.adf.model.node.type.ContentNode Scan existing ADF content and/or modify to it}</li>
 *     <li>{@link com.atlassian.adf.model.node.type.ContentNode#content(com.atlassian.adf.model.node.Node) Add
 *     more content to an existing ADF node}</li>
 * </ul>
 * <h1>Okay, That Was TOO Quick!</h1>
 * This library provides a Java API for building, parsing, and manipulating ADF documents.
 * The Atlassian Document Format is a JSON-encoded representation of rich content used by multiple
 * Atlassian Cloud products, notably both Jira and Confluence.
 * <p>
 * While the focus has been heavily weighted towards feature development rather than public
 * documentation of this API for an extended period, this shortcoming is now (late 2022) starting
 * to receive significant attention as we try to enable ecosystem developers to make use of the
 * richer content options that ADF provides. While the Javadocs for this library are by no means
 * an adequate replacement for the proper documentation to come, hopefully they provide enough
 * detail to bridge the gap in the meantime.
 * <p>
 * The primary library, which uses {@code groupId} {@code com.atlassian.adf} and {@code artifactId}
 * {@code adf-builder-java} provides three main capabilities:
 * <ol>
 *     <li>Building &mdash; Each node and mark type has {@code static} factories for creating nodes
 *     of that type and composing them to form ADF. The nodes (including {@code Doc} itself) contain
 *     define a {@link com.atlassian.adf.model.Element#toMap() toMap()} method whose output can be
 *     serialized by your favorite JSON library to create valid input for Atlassian APIs that require
 *     ADF values.</li>
 *
 *     <li>Parsing &mdash; The {@link com.atlassian.adf.model.node.Doc Doc} node has a
 *     {@link com.atlassian.adf.model.node.Doc#parse(java.util.Map)} parse} method that accepts a
 *     <code>Map&lt;String, ?&gt;</code> structure and parses it to the same concrete
 *     classes that are used when Building. When accepting ADF output from Atlassian APIs, your
 *     favorite JSON library can parse the value to a <code>Map&lt;String, Object&gt;</code> and
 *     use this method to map it to concrete classes that can be used to interpret the content.</li>
 *
 *     <li>Manipulating &mdash; Whether building a new document or parsing a new one, the concrete
 *     classes representing the various nodes and marks in the ADF structure are mutable within this
 *     library, providing a rich and context-aware API for modifying the content while maintaining
 *     the correctness of its structure. See the individual node and mark classes for more information
 *     about what changes can be made and any related caveats.</li>
 * </ol>
 * Additionally, separate modules are provided for gluing your favorite JSON library directly into
 * the {@code Doc} class's {@code parse} and {@code toMap} methods so that you never have to deal with
 * the intermediate <code>Map&lt;String, Object&gt;</code> data format yourself.
 *
 * @see com.atlassian.adf.model.node.Doc Doc
 * @see com.atlassian.adf.model.node nodes
 * @see com.atlassian.adf.model.mark marks
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/">Atlassian
 * Document Format</a>
 */
//TODO https://hello.atlassian.net/wiki/spaces/~oobut/pages/1852830775/Demystifying+ADF#Introduce-http%3A%2F%2Fdeveloper.atlassian.com%2Fplatform%2Fadf
// This page discusses the possibility of introducing https://developer.atlassian.com/platform/adf/ as the new
// public-facing documentation for ADF. If/when that ever happens, the links to the Jira-specific "dinosaur" docs
// should be replaced with that new hotness.
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@PublicApi
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.model;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;