package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.node.Node;

/**
 * Marks the nodes that can be placed directly into a {@code tableRow} node.
 * In practice, this interface is redundant with {@link TableCellNode}, as that abstracts
 * the common features of {@code tableHeader} and {@code tableCell}, which also happen to
 * be the only two node types that are usable within a {@code tableRow}. However, they
 * serve different functional purposes in this library's type system, so they are both
 * included for consistency with the other interfaces that mark either common functionality
 * or the context within which they may be used.
 */
public interface TableRowContent extends Node {
}
