package com.atlassian.adf.model.node.type;

import javax.annotation.Nullable;
import java.util.Optional;

/**
 * Describes features that are common to {@code tableHeader} and {@code tableCell} nodes.
 */
public interface TableCellNode<N extends TableCellNode<N>>
        extends TableRowContent, ContentNode<N, TableCellContent> {

    /**
     * @return {@code true} for a {@code tableHeader} or {@code false} for a {@code tableCell}
     */
    boolean isHeader();

    /**
     * Returns the background color for the table cell, if one is set.
     *
     * @return the background color for the table cell, or {@code empty()} if not set
     */
    Optional<String> background();

    /**
     * Sets the background color for the table cell.
     *
     * @param background short or long hex color code or <a href="http://dev.w3.org/csswg/css-color/#named-colors">HTML color name</a>
     * @return {@code this}
     */
    N background(@Nullable String background);

    /**
     * Returns the rowspan setting for the table cell, if one is set.
     *
     * @return the rowspan setting for the table cell, or {@code empty()} if not set
     */
    Optional<Integer> rowspan();

    /**
     * Sets the number of rows that the table cell spans.
     *
     * @param rowspan a positive integer, default 1.
     * @return {@code this}
     */
    N rowspan(@Nullable Integer rowspan);

    /**
     * Returns the colspan setting for the table cell, if one is set.
     *
     * @return the colspan setting for the table cell, or {@code empty()} if not set
     */
    Optional<Integer> colspan();

    /**
     * Returns the column widths for the table cell's spanned columns, if set.
     *
     * @return the column widths for the table cell's spanned columns, or {@code empty()} if not set
     */
    Optional<int[]> colwidth();

    /**
     * Sets the number of columns that the table cell spans, as well as the widths of those columns.
     *
     * @param colspan  a positive integer, default 1.
     * @param colwidth an array of non-negative integers, at least one of which is positive, and with exactly one
     *                 value for each of the columns counted by {@code colspan} (meaning exactly 1 if {@code colspan}
     *                 is {@code null}). As an example, {@code colspanAndColwidth(3, new int[] {120, 0, 120})} is a
     *                 valid request.
     * @return {@code this}
     */
    N colspanAndColwidth(@Nullable Integer colspan, @Nullable int[] colwidth);

    N content(String content);

    N content(String... content);
}
