package com.atlassian.adf.model.node;

import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;

import javax.annotation.concurrent.Immutable;
import java.util.Map;

import static com.atlassian.adf.util.ParserSupport.checkType;

/**
 * Representing a divider, this is equivalent to an HTML {@code <hr/>} tag.
 * <h2>Example</h2>
 * <h3>Java</h3>
 * <pre>
 * {@link Doc#doc(DocContent[]) doc}(
 *         {@link Paragraph#p(String) p}("Hello"),
 *         {@link #hr() hr}(),
 *         {@link Paragraph#p(String) p}("World"),
 * );
 * </pre>
 * <h3>ADF</h3>
 * <pre>{@code
 *   {
 *     "version": 1,
 *     "type": "doc",
 *     "content": [
 *       {
 *         "type": "paragraph",
 *         "content": [
 *           {
 *             "type": "text",
 *             "text": "Hello"
 *           }
 *         ]
 *       },
 *       {
 *         "type": "rule"
 *       },
 *       {
 *         "type": "paragraph",
 *         "content": [
 *           {
 *             "type": "text",
 *             "text": "World"
 *           }
 *         ]
 *       },
 *     ]
 *   }
 * }</pre>
 * <h3>Result</h3>
 * <div style="color: rgb(23, 43, 77); background-color: #ffffff;">
 * <p>Hello</p>
 * <hr>
 * <p>World</p>
 * </div>
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/apis/document/nodes/rule/">Node - rule</a>
 */
@Immutable
public class Rule
        extends AbstractNode<Rule>
        implements DocContent, LayoutColumnContent, NonNestableBlockContent, TableCellContent {

    static Factory<Rule> FACTORY = new Factory<>(Type.RULE, Rule.class, Rule::parse);

    private static final Rule RULE = new Rule();

    private Rule() {
        // singleton
    }

    public static Rule rule() {
        return RULE;
    }

    public static Rule hr() {
        return RULE;
    }

    @Override
    public Rule copy() {
        return this;
    }

    @Override
    public String elementType() {
        return Type.RULE;
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, ?> toMap() {
        return mapWithType();
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        // Deliberately suppress default handling. We don't want to see "[rule]" for this.
    }

    private static Rule parse(Map<String, ?> map) {
        checkType(map, Type.RULE);
        return hr();
    }

}
