package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.util.Factory;

import java.util.Map;
import java.util.stream.Stream;

import static com.atlassian.adf.model.node.Text.text;
import static com.atlassian.adf.util.ParserSupport.checkType;

/**
 * Wraps the caption content that may optionally be assigned to a {@link MediaSingle mediaSingle} node.
 */
@Documentation(state = Documentation.State.UNDOCUMENTED, date = "2023-07-26")
public class Caption
        extends AbstractContentNode<Caption, CaptionContent> {

    static final Factory<Caption> FACTORY = new Factory<>(Type.CAPTION, Caption.class, Caption::parse);

    private Caption() {
    }

    public static Caption caption() {
        return new Caption();
    }

    public static Caption caption(String content) {
        return new Caption().content(content);
    }

    public static Caption caption(String... content) {
        return new Caption().content(content);
    }

    public static Caption caption(CaptionContent content) {
        return new Caption().content(content);
    }

    public static Caption caption(CaptionContent... content) {
        return new Caption().content(content);
    }

    public static Caption caption(Iterable<? extends CaptionContent> content) {
        return new Caption().content(content);
    }

    public static Caption caption(Stream<? extends CaptionContent> content) {
        return new Caption().content(content);
    }

    public Caption content(String content) {
        return content(text(content));
    }

    public Caption content(String... content) {
        return content(text(content));
    }

    @Override
    public Caption copy() {
        return parse(toMap());
    }

    @Override
    public String elementType() {
        return Type.CAPTION;
    }

    @Override
    public Map<String, ?> toMap() {
        return mapWithType()
                .let(this::addContent);
    }

    private static Caption parse(Map<String, ?> map) {
        checkType(map, Type.CAPTION);
        return new Caption()
                .parseRequiredContentAllowEmpty(map, CaptionContent.class);
    }
}
