package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.node.Node;

import static java.util.Objects.requireNonNull;

/**
 * Reports a problem with an ADF node.
 */
public abstract class NodeException extends AdfException {
    private static final long serialVersionUID = 1L;

    NodeException(String message) {
        super(message);
    }

    /**
     * Reports that the {@code type} of node used does not implement the class that is required
     * in the given {@code parentType} node's {@code content}. For example, {@code tableCell} nodes
     * cannot contain {@code text} nodes directly (they must be wrapped inside of a {@code paragraph}),
     * and this exception is thrown if a document tries to place one there.
     */
    public static class TypeMismatch extends NodeException {
        private static final long serialVersionUID = 1L;

        private final String parentType;
        private final Class<? extends Node> requiredClass;
        private final String type;

        public TypeMismatch(String parentType, Class<? extends Node> requiredClass, String type) {
            super("incorrect node type for this context: parentType=" + parentType +
                    "; required=" + requiredClass.getSimpleName() +
                    "; type=" + type);
            this.parentType = parentType;
            this.requiredClass = requireNonNull(requiredClass, "requiredClass");
            this.type = requireNonNull(type, "type");
        }

        public String parentType() {
            return parentType;
        }

        public Class<? extends Node> requiredClass() {
            return requiredClass;
        }

        public String type() {
            return type;
        }

    }
}
