package com.atlassian.adf.model.ex.node;

/**
 * Reports a problem with a {@code heading} node.
 */
public abstract class HeadingException extends NodeException {
    private static final long serialVersionUID = 1L;

    HeadingException(String message) {
        super(message);
    }

    /**
     * Reports that a {@code heading} node specified a {@code level} that is out of range.
     * Only the values from {@code 1} to {@code 6} are supported.
     */
    public static class InvalidLevel extends HeadingException {
        private static final long serialVersionUID = 1L;

        private final int level;

        public InvalidLevel(int level) {
            super("Only heading levels 1 through 6 are supported: " + level);
            this.level = level;
        }

        public int level() {
            return level;
        }
    }
}
