package com.atlassian.adf.model.ex.node;

/**
 * Reports a problem with a {@code hardBreak} node.
 */
public abstract class HardBreakException extends NodeException {
    private static final long serialVersionUID = 1L;

    HardBreakException(String message) {
        super(message);
    }

    /**
     * The rather useless {@code text} attribute on {@code hardBreak} nodes is usually omitted, and when specified
     * is only permitted to use the value {@code "\n"} &mdash; that is, a single newline character.
     */
    public static class TextMustBeNewline extends HardBreakException {
        private static final long serialVersionUID = 1L;

        public TextMustBeNewline() {
            super("If present, the 'text' attribute must be a newline character");
        }
    }
}
