package com.atlassian.adf.model.ex.mark;

import com.atlassian.adf.model.ex.AdfException;

/**
 * Reports a problem with an {@code indentation} mark.
 */
public abstract class IndentationException extends AdfException {
    private static final long serialVersionUID = 1L;

    IndentationException(String message) {
        super(message);
    }


    /**
     * Reports that an {@code indentation} mark specified a {@code level} that is out of range.
     * Only the values from {@code 1} to {@code 6} are supported.
     */
    public static class InvalidLevel extends IndentationException {
        private static final long serialVersionUID = 1L;

        private final int level;

        public InvalidLevel(int level) {
            super("Only indentation levels 1 through 6 are supported: " + level);
            this.level = level;
        }

        public int level() {
            return level;
        }
    }
}
