/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.util.Char;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;

@Internal
public class UrlUtil {
    static final int LONGEST_VALID_SCHEME = 15;
    static final Set<String> URN_VALID_SCHEMES = Set.of("callto", "cvs", "facetime", "feed", "git", "irc", "irc6", "itms", "magnet", "mailto", "mvn", "news", "nntp", "notes", "rdp", "skype", "sip", "sips", "slack", "sourcetree", "ssh", "svn", "tel", "telnet", "urn", "vnc", "whatsapp", "xmpp");
    static final Set<String> URL_VALID_SCHEMES = Set.of("dynamicsnav", "jamfselfservice", "file", "ftp", "ftps", "gopher", "hipchat", "http", "https", "integrity", "scp", "sftp", "smb");

    private UrlUtil() {
    }

    public static String escapeSpecialChars(String url) {
        StringBuilder sb = new StringBuilder(url.length());
        int mark = 0;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (UrlUtil.isLegalChar(c)) continue;
            if (mark < i) {
                sb.append(url, mark, i);
            }
            mark = i + 1;
            UrlUtil.appendEscaped(sb, c);
        }
        if (mark < url.length()) {
            sb.append(url, mark, url.length());
        }
        return sb.toString();
    }

    @VisibleForTesting
    static void appendEscaped(StringBuilder sb, char c) {
        if (c < '\u0080') {
            UrlUtil.appendEscapedByte(sb, c);
        } else if (c < '\u0800') {
            UrlUtil.appendEscapedByte(sb, 0xC0 | c >> 6);
            UrlUtil.appendEscapedByte(sb, 0x80 | c & 0x3F);
        } else {
            UrlUtil.appendEscapedByte(sb, 0xE0 | c >> 12);
            UrlUtil.appendEscapedByte(sb, 0x80 | c >> 6 & 0x3F);
            UrlUtil.appendEscapedByte(sb, 0x80 | c & 0x3F);
        }
    }

    private static void appendEscapedByte(StringBuilder sb, int byteVal) {
        sb.append('%').append(Char.hex(byteVal >> 4)).append(Char.hex(byteVal & 0xF));
    }

    public static boolean isSafeUrl(String url) {
        String urlTrimmed = url.trim();
        if (urlTrimmed.isEmpty()) {
            return true;
        }
        char c = urlTrimmed.charAt(0);
        if (c == '/' || c == '#') {
            return true;
        }
        if (!Char.isAlpha(c)) {
            return false;
        }
        int stop = Integer.min(urlTrimmed.length(), 15);
        int i = 1;
        while (true) {
            if (i >= stop) {
                return false;
            }
            c = urlTrimmed.charAt(i);
            if (c == ':') break;
            if (!Char.isAlnum(c)) {
                return false;
            }
            ++i;
        }
        String scheme = urlTrimmed.substring(0, i).toLowerCase(Locale.ROOT);
        if (URN_VALID_SCHEMES.contains(scheme)) {
            return true;
        }
        if (!URL_VALID_SCHEMES.contains(scheme)) {
            return false;
        }
        if (i + 2 >= urlTrimmed.length()) {
            return false;
        }
        return urlTrimmed.charAt(i + 1) == '/' && urlTrimmed.charAt(i + 2) == '/';
    }

    public static String validateUrl(String url, String propertyName) {
        String urlTrimmed = url.trim();
        if (urlTrimmed.isEmpty()) {
            return "";
        }
        try {
            String parsed = new URI(urlTrimmed).toString();
            if (!UrlUtil.isSafeUrl(parsed)) {
                throw new AdfException.InvalidURI(propertyName, urlTrimmed);
            }
            return urlTrimmed;
        }
        catch (URISyntaxException e) {
            String escaped = UrlUtil.escapeSpecialChars(urlTrimmed);
            if (!escaped.equals(urlTrimmed)) {
                try {
                    String parsed = new URI(escaped).toString();
                    if (!UrlUtil.isSafeUrl(parsed)) {
                        throw new AdfException.InvalidURI(propertyName, urlTrimmed);
                    }
                    return urlTrimmed;
                }
                catch (URISyntaxException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw new AdfException.InvalidURI(propertyName, urlTrimmed, e);
        }
    }

    private static boolean isLegalChar(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '_': 
            case '~': {
                return true;
            }
        }
        if (Char.isAlnum(c)) {
            return true;
        }
        if (c < '\u0080') {
            return false;
        }
        return !Character.isSpaceChar(c) && !Character.isISOControl(c);
    }
}

