/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.type.MediaInlineMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class MediaInline
extends AbstractMarkedNode<MediaInline, MediaInlineMark>
implements InlineContent {
    static Factory<MediaInline> FACTORY = new Factory<MediaInline>("mediaInline", MediaInline.class, MediaInline::parse);
    private String id;
    private String collection = "";
    @Nullable
    private MediaType mediaType;
    @Nullable
    private String occurrenceKey;
    @Nullable
    private Number width;
    @Nullable
    private Number height;
    @Nullable
    private String alt;
    @Nullable
    private Map<String, ?> data;

    private MediaInline(String id) {
        this.id = MediaInline.validateId(id);
    }

    public MediaInline link(@Nullable Link link) {
        this.marks.remove("link");
        if (link != null) {
            this.marks.add(link);
        }
        return this;
    }

    public MediaInline link(@Nullable String href) {
        return this.link(href != null ? Link.link(href) : null);
    }

    public MediaInline data(@Nullable Map<String, ?> data) {
        this.data = data != null ? FieldMap.immutableCopy(data) : null;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MediaInline id(String id) {
        this.id = MediaInline.validateId(id);
        return this;
    }

    public String collection() {
        return this.collection;
    }

    public MediaInline collection(@Nullable String collection) {
        this.collection = MediaInline.validateCollection(collection);
        return this;
    }

    public Optional<String> occurrenceKey() {
        return Optional.ofNullable(this.occurrenceKey);
    }

    public MediaInline occurrenceKey(@Nullable String occurrenceKey) {
        this.occurrenceKey = MediaInline.validateOccurrenceKey(occurrenceKey);
        return this;
    }

    public static Partial.NeedsId mediaInline() {
        return new Partial.NeedsId(null);
    }

    public static MediaInline mediaInline(String id) {
        return new MediaInline(id);
    }

    public static Partial.NeedsId mediaInlineFile() {
        return new Partial.NeedsId(MediaType.FILE);
    }

    public static MediaInline mediaInlineFile(String id) {
        return MediaInline.mediaInline(id).file();
    }

    public static Partial.NeedsId mediaInlineLink() {
        return new Partial.NeedsId(MediaType.LINK);
    }

    public static MediaInline mediaInlineLink(String id) {
        return MediaInline.mediaInline(id).link();
    }

    public MediaInline file() {
        return this.mediaType(MediaType.FILE);
    }

    public MediaInline link() {
        return this.mediaType(MediaType.LINK);
    }

    public MediaInline mediaType(@Nullable String mediaType) {
        return this.mediaType(MediaType.PARSER.parseAllowNull(mediaType));
    }

    public MediaInline mediaType(@Nullable MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public MediaInline width(Number width) {
        Element.nonNull(width, "width");
        if (width.doubleValue() <= 0.0) {
            throw new MediaException.WidthMustBePositive(width);
        }
        this.width = width;
        return this;
    }

    public Optional<Number> height() {
        return Optional.ofNullable(this.height);
    }

    public MediaInline height(Number height) {
        Element.nonNull(height, "height");
        if (height.doubleValue() <= 0.0) {
            throw new MediaException.HeightMustBePositive(height);
        }
        this.height = height;
        return this;
    }

    public MediaInline size(Number width, Number height) {
        return this.width(width).height(height);
    }

    public MediaInline alt(@Nullable String alt) {
        this.alt = alt;
        return this;
    }

    public MediaInline linkMark(@Nullable Link link) {
        return this.link(link);
    }

    public MediaInline linkMark(@Nullable URL url) {
        return this.link(url != null ? Link.link(url) : null);
    }

    public MediaInline linkMark(@Nullable String href) {
        return this.link(href != null ? Link.link(href) : null);
    }

    public Optional<Link> linkMark() {
        return this.marks.get("link").map(Link.class::cast);
    }

    public Optional<Map<String, ?>> data() {
        return Optional.ofNullable(this.data);
    }

    public static MediaInline mediaInline(String id, @Nullable String collection) {
        return new MediaInline(id).collection(collection);
    }

    public static MediaInline mediaInline(String id, @Nullable MediaType mediaType, @Nullable String collection) {
        MediaInline mediaInline = new MediaInline(id).collection(collection);
        if (mediaType != null) {
            mediaInline.mediaType(mediaType);
        }
        return mediaInline;
    }

    @Override
    public MediaInline copy() {
        return MediaInline.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mediaInline";
    }

    @Override
    public Class<MediaInlineMark> markClass() {
        return MediaInlineMark.class;
    }

    @Override
    protected boolean markedNodeEquals(MediaInline other) {
        return this.id.equals(other.id) && this.collection.equals(other.collection) && Objects.equals(this.occurrenceKey, other.occurrenceKey) && Objects.equals((Object)this.mediaType, (Object)other.mediaType) && Objects.equals(this.alt, other.alt) && MediaInline.numberEq(this.width, other.width) && MediaInline.numberEq(this.height, other.height);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(new Object[]{this.id, this.collection, this.occurrenceKey, this.mediaType, MediaInline.numberHash(this.width), MediaInline.numberHash(this.height), this.alt});
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("id", this.id);
        buf.appendField("collection", this.collection);
        buf.appendField("occurrenceKey", this.occurrenceKey);
        buf.appendField("mediaType", (Object)this.mediaType);
        buf.appendField("width", this.width);
        buf.appendField("height", this.height);
        buf.appendField("alt", this.alt);
        buf.appendField("data", this.data);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("id", this.id).add("collection", this.collection).addMappedIfPresent("type", this.mediaType, MediaType::mediaType).addIfPresent("occurrenceKey", this.occurrenceKey).addIfPresent("width", this.width).addIfPresent("height", this.height).addIfPresent("alt", this.alt).addIfPresent("data", this.data)).let(this.marks::addToMap);
    }

    private static MediaInline parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mediaInline");
        String id = (String)ParserSupport.getAttrOrThrow(map, "id");
        String collection = ParserSupport.getAttr(map, "collection", String.class).orElse(null);
        MediaInline mediaInline = new MediaInline(id).collection(collection);
        ParserSupport.getAttrNumber(map, "width").ifPresent(mediaInline::width);
        ParserSupport.getAttrNumber(map, "height").ifPresent(mediaInline::height);
        ParserSupport.getAttr(map, "type", String.class).ifPresent(mediaInline::mediaType);
        ParserSupport.getAttr(map, "alt", String.class).ifPresent(mediaInline::alt);
        ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(mediaInline::occurrenceKey);
        ParserSupport.getAttr(map, "data").ifPresent(data -> mediaInline.data((Map)Cast.unsafeCast(data)));
        return (MediaInline)mediaInline.parseMarks(map);
    }

    private static String validateId(String id) {
        return Element.nonEmpty(id, "id");
    }

    private static String validateCollection(@Nullable String collection) {
        return collection != null ? collection : "";
    }

    @Nullable
    private static String validateOccurrenceKey(@Nullable String occurrenceKey) {
        return occurrenceKey == null || !occurrenceKey.isEmpty() ? occurrenceKey : null;
    }

    public static enum MediaType {
        FILE("file"),
        LINK("link");

        static final EnumParser<MediaType> PARSER;
        private final String mediaType;

        private MediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public String mediaType() {
            return this.mediaType;
        }

        static {
            PARSER = new EnumParser<MediaType>(MediaType.class, MediaType::mediaType);
        }
    }

    public static interface Partial {

        public static class NeedsId
        extends CanSetMediaType<NeedsId> {
            NeedsId() {
                this(null);
            }

            NeedsId(@Nullable MediaType mediaType) {
                super(mediaType);
            }

            public MediaInline id(String id) {
                return new MediaInline(id).mediaType(this.mediaType);
            }
        }

        public static abstract class CanSetMediaType<T extends CanSetMediaType<T>> {
            @Nullable
            protected MediaType mediaType;

            CanSetMediaType(@Nullable MediaType mediaType) {
                this.mediaType = mediaType;
            }

            public T file() {
                return this.mediaType(MediaType.FILE);
            }

            public T link() {
                return this.mediaType(MediaType.LINK);
            }

            public T mediaType(String mediaType) {
                return this.mediaType(MediaType.PARSER.parse(mediaType));
            }

            public T mediaType(MediaType mediaType) {
                this.mediaType = mediaType;
                return (T)((CanSetMediaType)Cast.unsafeCast(this));
            }
        }
    }
}

