/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.CardException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class EmbedCard
extends AbstractNode<EmbedCard>
implements DocContent,
LayoutColumnContent,
NonNestableBlockContent,
TableCellContent {
    static final Factory<EmbedCard> FACTORY = new Factory<EmbedCard>("embedCard", EmbedCard.class, EmbedCard::parse);
    private Layout layout;
    private String url;
    @Nullable
    private Number originalWidth;
    @Nullable
    private Number originalHeight;
    @Nullable
    private Number width;

    private EmbedCard(Layout layout, String url) {
        this.layout = Objects.requireNonNull(layout, "layout");
        this.url = Objects.requireNonNull(url, "url");
    }

    public static EmbedCard embedCard(Layout layout, URL url) {
        Objects.requireNonNull(layout, "layout");
        Objects.requireNonNull(url, "url");
        String uri = url.toString();
        uri = ParserSupport.cleanUri(uri, "url");
        return new EmbedCard(layout, uri);
    }

    public static EmbedCard embedCard(Layout layout, URI url) {
        Objects.requireNonNull(layout, "layout");
        Objects.requireNonNull(url, "url");
        return new EmbedCard(layout, url.toString());
    }

    public static Partial.NeedsLayout embedCard() {
        return new Partial.NeedsLayout();
    }

    public static Partial.NeedsUrl embedCard(String layout) {
        return new Partial.NeedsUrl(layout);
    }

    public static Partial.NeedsUrl embedCard(Layout layout) {
        return new Partial.NeedsUrl(layout);
    }

    public Layout layout() {
        return this.layout;
    }

    public EmbedCard layout(String layout) {
        return this.layout(Layout.PARSER.parse(layout));
    }

    public EmbedCard layout(Layout layout) {
        this.layout = Objects.requireNonNull(layout, "layout");
        return this;
    }

    public String url() {
        return this.url;
    }

    public EmbedCard url(String url) {
        this.url = ParserSupport.cleanUri(url, "url");
        return this;
    }

    public EmbedCard url(URL url) {
        this.url = ParserSupport.cleanUri(url, "url");
        return this;
    }

    public EmbedCard url(URI url) {
        this.url = ParserSupport.cleanUri(url, "url");
        return this;
    }

    public EmbedCard originalWidth(Number originalWidth) {
        this.originalWidth = originalWidth;
        return this;
    }

    public Optional<Number> originalWidth() {
        return Optional.ofNullable(this.originalWidth);
    }

    public EmbedCard originalHeight(Number originalHeight) {
        this.originalHeight = originalHeight;
        return this;
    }

    public Optional<Number> originalHeight() {
        return Optional.ofNullable(this.originalHeight);
    }

    public EmbedCard width(@Nullable Number width) {
        if (width != null) {
            double widthDouble = width.doubleValue();
            if (widthDouble < 0.0 || widthDouble > 100.0) {
                throw new CardException.InvalidWidth(width);
            }
            this.width = width;
        }
        return this;
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public EmbedCard originalSize(Number originalWidth, Number originalHeight) {
        return this.originalWidth(originalWidth).originalHeight(originalHeight);
    }

    @Override
    public EmbedCard copy() {
        return EmbedCard.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "embedCard";
    }

    @Override
    protected boolean nodeEquals(EmbedCard other) {
        return this.layout == other.layout && this.url.equals(other.url) && EmbedCard.numberEq(this.originalWidth, other.originalWidth) && EmbedCard.numberEq(this.originalHeight, other.originalHeight) && EmbedCard.numberEq(this.width, other.width);
    }

    @Override
    protected int nodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.url, EmbedCard.numberHash(this.originalWidth), EmbedCard.numberHash(this.originalHeight), EmbedCard.numberHash(this.width)});
    }

    @Override
    protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("layout", (Object)this.layout);
        buf.appendField("url", this.url);
        buf.appendField("originalWidth", this.originalWidth);
        buf.appendField("originalHeight", this.originalHeight);
        buf.appendField("width", this.width);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().addMapped("layout", this.layout, Layout::layout).add("url", this.url).addIfPresent("originalWidth", this.originalWidth).addIfPresent("originalHeight", this.originalHeight).addIfPresent("width", this.width));
    }

    @Override
    public void validate() {
    }

    private static EmbedCard parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "embedCard");
        Layout layout = Layout.PARSER.parse(ParserSupport.getAttrOrThrow(map, "layout", String.class));
        String url = ParserSupport.getAttrOrThrow(map, "url", String.class);
        EmbedCard embedCard = new EmbedCard(layout, url);
        ParserSupport.getAttrNumber(map, "originalWidth").ifPresent(embedCard::originalWidth);
        ParserSupport.getAttrNumber(map, "originalHeight").ifPresent(embedCard::originalHeight);
        ParserSupport.getAttrNumber(map, "width").ifPresent(embedCard::width);
        return embedCard;
    }

    public static interface Partial {

        public static class NeedsUrl {
            private final Layout layout;

            NeedsUrl(String layout) {
                this(Layout.PARSER.parse(layout));
            }

            NeedsUrl(Layout layout) {
                this.layout = Objects.requireNonNull(layout, "layout");
            }

            public EmbedCard url(String url) {
                return new EmbedCard(this.layout, ParserSupport.cleanUri(url, "url"));
            }

            public EmbedCard url(URL url) {
                return this.url(Objects.requireNonNull(url, "url").toString());
            }

            public EmbedCard url(URI url) {
                return new EmbedCard(this.layout, Objects.requireNonNull(url, "url").toString());
            }
        }

        public static class NeedsLayout {
            NeedsLayout() {
            }

            public NeedsUrl layout(String layout) {
                return new NeedsUrl(layout);
            }

            public NeedsUrl layout(Layout layout) {
                return new NeedsUrl(layout);
            }
        }
    }

    public static enum Layout {
        WIDE("wide"),
        FULL_WIDTH("full-width"),
        CENTER("center"),
        WRAP_RIGHT("wrap-right"),
        WRAP_LEFT("wrap-left"),
        ALIGN_END("align-end"),
        ALIGN_START("align-start");

        static final EnumParser<Layout> PARSER;
        private final String layout;

        private Layout(String layout) {
            this.layout = layout;
        }

        public String layout() {
            return this.layout;
        }

        static {
            PARSER = new EnumParser<Layout>(Layout.class, Layout::layout);
        }
    }
}

