/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.DateUtil;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.time.Instant;
import java.util.Map;

public class Date
extends AbstractNode<Date>
implements CaptionContent,
InlineContent {
    static final Factory<Date> FACTORY = new Factory<Date>("date", Date.class, Date::parse);
    private String timestamp;

    private Date(String timestamp) {
        this.timestamp = Date.validateTimestamp(timestamp);
    }

    public static Partial.NeedsTimestamp date() {
        return new Partial.NeedsTimestamp();
    }

    public static Date date(String timestamp) {
        return new Date(timestamp);
    }

    public static Date date(long epochMillis) {
        return Date.date(Instant.ofEpochMilli(epochMillis));
    }

    public static Date date(Instant instant) {
        return new Date(instant.toString());
    }

    public static Date date(java.util.Date date) {
        return Date.date(date.getTime());
    }

    public Date timestamp(String timestamp) {
        this.timestamp = Date.validateTimestamp(timestamp);
        return this;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public String elementType() {
        return "date";
    }

    @Override
    public Date copy() {
        return Date.parse(this.toMap());
    }

    @Override
    public void validate() {
    }

    @Override
    protected boolean nodeEquals(Date other) {
        return this.timestamp.equals(other.timestamp);
    }

    @Override
    protected int nodeHashCode() {
        return this.timestamp.hashCode();
    }

    @Override
    protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("timestamp", this.timestamp);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("timestamp", this.timestamp));
    }

    private static Date parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "date");
        String timestamp = (String)ParserSupport.getAttrOrThrow(map, "timestamp");
        return Date.date(timestamp);
    }

    private static String validateTimestamp(String timestamp) {
        return Element.nonEmpty(timestamp, "timestamp");
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append(DateUtil.timestampToIsoFormat(this.timestamp));
    }

    public static interface Partial {

        public static class NeedsTimestamp {
            NeedsTimestamp() {
            }

            public Date timestamp(String timestamp) {
                return new Date(timestamp);
            }
        }
    }
}

