/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.type.CodeBlockMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class CodeBlock
extends AbstractMarkedContentNode<CodeBlock, Text, CodeBlockMark>
implements DocContent,
LayoutColumnContent,
ListItemContent,
NonNestableBlockContent,
TableCellContent {
    static Factory<CodeBlock> FACTORY = new Factory<CodeBlock>("codeBlock", CodeBlock.class, CodeBlock::parse);
    @Nullable
    private String language;

    private CodeBlock() {
    }

    public static CodeBlock codeBlock() {
        return new CodeBlock();
    }

    public static CodeBlock codeBlock(String content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(String ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(Text content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Text ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock pre() {
        return new CodeBlock();
    }

    public static CodeBlock pre(String content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(String ... content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(Text content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Text ... content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    @Override
    public CodeBlock copy() {
        return CodeBlock.parse(this.toMap());
    }

    @Override
    public CodeBlock content(String content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    @Override
    public CodeBlock content(String ... content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    public Optional<String> language() {
        return Optional.ofNullable(this.language);
    }

    public CodeBlock language(@Nullable String language) {
        this.language = language;
        return this;
    }

    public Optional<Breakout> breakout() {
        return this.marks.get("breakout").map(Breakout.class::cast);
    }

    public CodeBlock breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public CodeBlock wide() {
        return this.breakout(Breakout.wide());
    }

    public CodeBlock fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public CodeBlock defaultWidth() {
        return this.breakout(null);
    }

    @Override
    protected void validateContentNodeForAppend(Text node) {
        super.validateContentNodeForAppend(node);
        node.disableMarks(this);
    }

    @Override
    public String elementType() {
        return "codeBlock";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().addIf(this.language != null, "attrs", () -> FieldMap.map("language", this.language)).let(this::addContentIfPresent).let(this.marks::addToMap);
    }

    private static CodeBlock parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "codeBlock");
        CodeBlock pre = (CodeBlock)CodeBlock.pre().parseOptionalContent(map, Text.class);
        ParserSupport.getAttr(map, "language", String.class).ifPresent(pre::language);
        return (CodeBlock)pre.parseMarks(map);
    }

    @Override
    public Class<CodeBlockMark> markClass() {
        return CodeBlockMark.class;
    }

    @Override
    protected boolean markedContentNodeEquals(CodeBlock other) {
        return Objects.equals(this.language, other.language);
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hashCode(this.language);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("language", this.language);
    }

    void disableMarks(ContentNode<?, ? super CodeBlock> parent) {
        this.marks.disable(parent.elementType());
    }
}

