/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.type.BodiedExtensionMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class BodiedExtension
extends AbstractMarkedContentNode<BodiedExtension, NonNestableBlockContent, BodiedExtensionMark>
implements ExtensionNode<BodiedExtension, BodiedExtensionMark>,
DocContent,
LayoutColumnContent {
    static final Factory<BodiedExtension> FACTORY = new Factory<BodiedExtension>("bodiedExtension", BodiedExtension.class, BodiedExtension::parse);
    private final ExtensionSettings settings;
    @Nullable
    private ExtensionSettings.Layout layout;

    private BodiedExtension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<BodiedExtension> bodiedExtension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<BodiedExtension>(BodiedExtension::new);
    }

    public static BodiedExtension bodiedExtension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(BodiedExtension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public BodiedExtension copy() {
        return BodiedExtension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "bodiedExtension";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs().addMappedIfPresent("layout", this.layout, ExtensionSettings.Layout::layout)).let(this::addContent).let(this.marks::addToMap);
    }

    @Override
    protected void validateContentNodeForAppend(NonNestableBlockContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof Heading) {
            ((Heading)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        }
    }

    @Override
    public Class<BodiedExtensionMark> markClass() {
        return BodiedExtensionMark.class;
    }

    @Override
    protected void markedContentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.settings});
    }

    @Override
    protected boolean markedContentNodeEquals(BodiedExtension other) {
        return this.layout == other.layout && this.settings.equals(other.settings);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        this.settings.appendExtensionFields(buf);
        buf.appendField("layout", (Object)this.layout);
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public BodiedExtension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public BodiedExtension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public BodiedExtension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public BodiedExtension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public BodiedExtension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    public BodiedExtension layout(String layout) {
        return this.layout(ExtensionSettings.Layout.PARSER.parse(layout));
    }

    public BodiedExtension layout(ExtensionSettings.Layout layout) {
        this.layout = layout;
        return this;
    }

    public Optional<ExtensionSettings.Layout> layout() {
        return Optional.ofNullable(this.layout);
    }

    private static BodiedExtension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        BodiedExtension extension = (BodiedExtension)new BodiedExtension(settings).parseRequiredContent(map, NonNestableBlockContent.class);
        ParserSupport.getAttr(map, "layout", String.class).ifPresent(layout -> extension.layout(ExtensionSettings.Layout.PARSER.parse((String)layout)));
        return (BodiedExtension)extension.parseMarks(map);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.settings.text().orElseGet(() -> UnsupportedNode.plainTextFallback(this));
        sb.append(text);
    }
}

