/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Factory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class AbstractMarkedContentNode<C extends AbstractMarkedContentNode<C, N, M>, N extends Node, M extends Mark>
extends AbstractContentNode<C, N>
implements ContentNode<C, N>,
Marked<C, M> {
    protected final MarkHolder<M> marks = Objects.requireNonNull(this.createMarkHolder(), "createMarkHolder()");

    AbstractMarkedContentNode() {
    }

    @Override
    public abstract Class<M> markClass();

    protected MarkHolder<M> createMarkHolder() {
        return MarkHolder.unlimited();
    }

    @Override
    public final Collection<M> marks() {
        return this.marks.get();
    }

    @Override
    public final Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public final <T extends M> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public final Optional<M> mark(String markType) {
        return this.marks.get(markType);
    }

    @Override
    public C mark(M mark) {
        this.marks.add(mark);
        return (C)((AbstractMarkedContentNode)this.self());
    }

    protected C parseMarks(Map<String, ?> map) {
        MarkParserSupport.parseMarks(map, this.markClass(), this.unsupportedMarkFactory(), this);
        return (C)((AbstractMarkedContentNode)this.self());
    }

    @Override
    protected final void contentNodeValidate() {
        this.marks.validate();
        this.markedContentNodeValidate();
    }

    protected void markedContentNodeValidate() {
    }

    @Nullable
    protected Factory<M> unsupportedMarkFactory() {
        return null;
    }

    @Override
    protected final int contentNodeHashCode() {
        return this.marks.hashCode() * 31 + this.markedContentNodeHashCode();
    }

    @Override
    protected final boolean contentNodeEquals(C other) {
        return this.markedContentNodeEquals(other) && this.marks.equals(((AbstractMarkedContentNode)other).marks);
    }

    @Override
    protected final void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        this.appendMarkedContentNodeFields(buf);
        buf.appendMarksField(this.marks);
    }

    protected int markedContentNodeHashCode() {
        return 0;
    }

    protected boolean markedContentNodeEquals(C other) {
        return true;
    }

    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
    }
}

