/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.ex.mark.DataConsumerException;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.type.BodiedExtensionMark;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.mark.type.InlineExtensionMark;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DataConsumer
extends AbstractMark
implements BodiedExtensionMark,
ExtensionMark,
InlineExtensionMark {
    static final Factory<DataConsumer> FACTORY = new Factory<DataConsumer>("dataConsumer", DataConsumer.class, DataConsumer::parse);
    private final Set<String> sources = new LinkedHashSet<String>();

    private DataConsumer() {
    }

    public static Partial.NeedsSource dataConsumer() {
        return new Partial.NeedsSource();
    }

    public static DataConsumer dataConsumer(String source) {
        return DataConsumer.dataConsumer(Stream.of(source));
    }

    public static DataConsumer dataConsumer(String ... sources) {
        return DataConsumer.dataConsumer(Arrays.stream(sources));
    }

    public static DataConsumer dataConsumer(Iterable<String> sources) {
        return DataConsumer.dataConsumer(StreamSupport.stream(sources.spliterator(), false));
    }

    public static DataConsumer dataConsumer(Stream<String> sources) {
        DataConsumer dataConsumer = new DataConsumer();
        sources.forEach(dataConsumer::source);
        dataConsumer.validate();
        return dataConsumer;
    }

    @Override
    public DataConsumer copy() {
        return DataConsumer.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "dataConsumer";
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sources.isEmpty()) {
            throw new DataConsumerException.NoSources();
        }
    }

    public DataConsumer source(String source) {
        Objects.requireNonNull(source, "source");
        if (!this.sources.add(source)) {
            throw new DataConsumerException.DuplicateSource(source);
        }
        return this;
    }

    public Set<String> sources() {
        return Collections.unmodifiableSet(this.sources);
    }

    @Override
    public Map<String, ?> toMap() {
        ArrayList<String> sources = new ArrayList<String>(this.sources);
        if (sources.isEmpty()) {
            throw new DataConsumerException.NoSources();
        }
        return this.mapWithType().add("attrs", FieldMap.map("sources", sources));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataConsumer && ((DataConsumer)o).sources.equals(this.sources);
    }

    public int hashCode() {
        return this.sources.hashCode();
    }

    @Override
    public String toString() {
        return this.elementType() + this.sources;
    }

    private static DataConsumer parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "dataConsumer");
        List sources = (List)Cast.unsafeCast(ParserSupport.getAttrOrThrow(map, "sources", List.class));
        if (sources.isEmpty()) {
            throw new DataConsumerException.NoSources();
        }
        DataConsumer dataConsumer = new DataConsumer();
        sources.forEach(dataConsumer::source);
        return dataConsumer;
    }

    public static interface Partial {

        public static class NeedsSource {
            NeedsSource() {
            }

            public DataConsumer source(String source) {
                return DataConsumer.dataConsumer(source);
            }

            public DataConsumer sources(String ... sources) {
                return DataConsumer.dataConsumer(sources);
            }

            public DataConsumer sources(Iterable<String> sources) {
                return DataConsumer.dataConsumer(sources);
            }

            public DataConsumer sources(Stream<String> sources) {
                return DataConsumer.dataConsumer(sources);
            }
        }
    }
}

