/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.util.Functions;
import com.atlassian.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class UrlUtil {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final List<Pattern> URL_PATTERN_ALLOW_LIST = UrlUtil.initAllowList();

    private UrlUtil() {
    }

    public static String escapeSpecialChars(String url) {
        StringBuilder sb = new StringBuilder(url.length());
        int mark = 0;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (UrlUtil.isLegalChar(c)) continue;
            if (mark < i) {
                sb.append(url, mark, i);
            }
            mark = i + 1;
            UrlUtil.appendEscaped(sb, c);
        }
        if (mark < url.length()) {
            sb.append(url, mark, url.length());
        }
        return sb.toString();
    }

    @VisibleForTesting
    static void appendEscaped(StringBuilder sb, char c) {
        if (c < '\u0080') {
            UrlUtil.appendEscapedByte(sb, c);
        } else if (c < '\u0800') {
            UrlUtil.appendEscapedByte(sb, 0xC0 | c >> 6);
            UrlUtil.appendEscapedByte(sb, 0x80 | c & 0x3F);
        } else {
            UrlUtil.appendEscapedByte(sb, 0xE0 | c >> 12);
            UrlUtil.appendEscapedByte(sb, 0x80 | c >> 6 & 0x3F);
            UrlUtil.appendEscapedByte(sb, 0x80 | c & 0x3F);
        }
    }

    private static void appendEscapedByte(StringBuilder sb, int byteVal) {
        sb.append('%').append(HEX[byteVal >> 4]).append(HEX[byteVal & 0xF]);
    }

    public static boolean isSafeUrl(String url) {
        String urlTrimmed = url.trim();
        if (urlTrimmed.isEmpty()) {
            return true;
        }
        return URL_PATTERN_ALLOW_LIST.stream().anyMatch(p -> p.matcher(urlTrimmed).find());
    }

    public static String validateUrl(String url, String propertyName) {
        String urlTrimmed = url.trim();
        if (urlTrimmed.isEmpty()) {
            return "";
        }
        try {
            String parsed = new URI(urlTrimmed).toString();
            if (!UrlUtil.isSafeUrl(parsed)) {
                throw new AdfException.InvalidURI(propertyName, urlTrimmed);
            }
            return urlTrimmed;
        }
        catch (URISyntaxException e) {
            String escaped = UrlUtil.escapeSpecialChars(urlTrimmed);
            if (!escaped.equals(urlTrimmed)) {
                try {
                    String parsed = new URI(escaped).toString();
                    if (!UrlUtil.isSafeUrl(parsed)) {
                        throw new AdfException.InvalidURI(propertyName, urlTrimmed);
                    }
                    return urlTrimmed;
                }
                catch (URISyntaxException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw new AdfException.InvalidURI(propertyName, urlTrimmed, e);
        }
    }

    private static boolean isLegalChar(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '_': 
            case '~': {
                return true;
            }
        }
        if (UrlUtil.isAlnum(c)) {
            return true;
        }
        if (c < '\u0080') {
            return false;
        }
        return !Character.isSpaceChar(c) && !Character.isISOControl(c);
    }

    private static List<Pattern> initAllowList() {
        HashSet seen = new HashSet(128);
        return Functions.mapToList(Stream.of("^https?://", "^ftps?://", "^/", "^#", "^mailto:", "^ssh:", "^vnc:", "^slack:", "^svn:", "^skype:", "^callto:", "^facetime:", "^git:", "^irc6?:", "^news:", "^nntp:", "^feed:", "^cvs:", "^mvn:", "^scp://", "^sftp://", "^itms:", "^notes:", "^hipchat://", "^sourcetree:", "^urn:", "^tel:", "^xmpp:", "^telnet:", "^rdp:", "^whatsapp:", "^sips?:", "^magnet:"), re -> {
            if (!seen.add(re)) {
                throw new IllegalArgumentException("Duplicate allow list pattern: [" + re + "]");
            }
            return Pattern.compile(re, 2);
        });
    }

    private static boolean isAlnum(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

