/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.ListException;
import com.atlassian.adf.model.node.AbstractListNode;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class OrderedList
extends AbstractListNode<OrderedList> {
    static Factory<OrderedList> FACTORY = new Factory<OrderedList>("orderedList", OrderedList.class, OrderedList::parse);
    @Nullable
    private Integer order;

    private OrderedList() {
    }

    public static OrderedList ol() {
        return new OrderedList();
    }

    public static OrderedList ol(ListItem ... content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().content(content);
    }

    public static OrderedList ol(int order) {
        return OrderedList.ol().order(order);
    }

    public static OrderedList ol(int order, ListItem ... content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList ol(int order, Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList ol(int order, Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public static OrderedList orderedList() {
        return new OrderedList();
    }

    public static OrderedList orderedList(ListItem ... content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().content(content);
    }

    public static OrderedList orderedList(int order) {
        return OrderedList.orderedList().order(order);
    }

    public static OrderedList orderedList(int order, ListItem ... content) {
        return (OrderedList)OrderedList.orderedList().order(order).content(content);
    }

    public static OrderedList orderedList(int order, Iterable<? extends ListItem> content) {
        return (OrderedList)OrderedList.orderedList().order(order).content(content);
    }

    public static OrderedList orderedList(int order, Stream<? extends ListItem> content) {
        return (OrderedList)OrderedList.ol().order(order).content(content);
    }

    public Optional<Integer> order() {
        return Optional.ofNullable(this.order);
    }

    public OrderedList order(@Nullable Integer order) {
        if (order != null && order <= 0) {
            throw new ListException.OrderMustBePositive(order);
        }
        this.order = order;
        return this;
    }

    @Override
    public OrderedList copy() {
        return OrderedList.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "orderedList";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).addIf(this.order != null, "attrs", () -> FieldMap.map("order", this.order));
    }

    private static OrderedList parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "orderedList");
        OrderedList ol = (OrderedList)OrderedList.ol().parseRequiredContent(map, ListItem.class);
        ParserSupport.getAttrInt(map, "order").ifPresent(ol::order);
        return ol;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.order, ((OrderedList)o).order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order);
    }

    @Override
    public String toString() {
        if (this.order == null) {
            return super.toString();
        }
        return "OrderedList[order=" + this.order + "; content=" + this.contentFieldMaps() + ']';
    }
}

