/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class CodeBlock
extends AbstractContentNode<CodeBlock, Text>
implements Marked<CodeBlock, Breakout>,
DocContent,
LayoutColumnContent,
ListItemContent,
NonNestableBlockContent,
TableCellContent {
    static Factory<CodeBlock> FACTORY = new Factory<CodeBlock>("codeBlock", CodeBlock.class, CodeBlock::parse);
    private final MarkHolder<Breakout> marks = MarkHolder.unlimited();
    @Nullable
    private String language;

    private CodeBlock() {
    }

    public static CodeBlock codeBlock() {
        return new CodeBlock();
    }

    public static CodeBlock codeBlock(String content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(String ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(Text content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Text ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock pre() {
        return new CodeBlock();
    }

    public static CodeBlock pre(String content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(String ... content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(Text content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Text ... content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    @Override
    public CodeBlock copy() {
        return CodeBlock.parse(this.toMap());
    }

    @Override
    public CodeBlock content(String content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    @Override
    public CodeBlock content(String ... content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    public Optional<String> language() {
        return Optional.ofNullable(this.language);
    }

    public CodeBlock language(@Nullable String language) {
        this.language = language;
        return this;
    }

    @Override
    public Collection<Breakout> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends Breakout> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public CodeBlock mark(Breakout mark) {
        this.marks.add(mark);
        return this;
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public CodeBlock breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public CodeBlock wide() {
        return this.breakout(Breakout.wide());
    }

    public CodeBlock fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public CodeBlock defaultWidth() {
        return this.breakout(null);
    }

    @Override
    protected void validateContentNodeForAppend(Text node) {
        super.validateContentNodeForAppend(node);
        node.disableMarks(this);
    }

    @Override
    public String elementType() {
        return "codeBlock";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).addIf(this.language != null, "attrs", () -> FieldMap.map("language", this.language)).let(this.marks::addToMap);
    }

    private static CodeBlock parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "codeBlock");
        CodeBlock pre = (CodeBlock)CodeBlock.pre().parseOptionalContent(map, Text.class);
        ParserSupport.getAttr(map, "language", String.class).ifPresent(pre::language);
        MarkParserSupport.parseBreakoutMark(map, pre);
        return pre;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.language, ((CodeBlock)o).language);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CodeBlock[");
        if (this.language != null) {
            sb.append("language=").append(this.language).append("; ");
        }
        if (!this.marks.isEmpty()) {
            sb.append("marks=").append(this.marks).append("; ");
        }
        return sb.append("content=").append(this.contentFieldMaps()).append(']').toString();
    }

    void disableMarks(ContentNode<?, ? super CodeBlock> parent) {
        this.marks.disable(parent.elementType());
    }
}

