/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.util.Cast;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class ParserSupport {
    private ParserSupport() {
    }

    public static <T> T get(Map<String, ?> map, String key) {
        return Cast.unsafeCast(map.get(key));
    }

    public static <T> T getOrThrow(Map<String, ?> map, String key) {
        return Cast.unsafeCast(Element.nonNull(map.get(key), key));
    }

    public static void checkType(Map<String, ?> map, String expectedType) {
        String type = ParserSupport.getTypeOrThrow(map);
        if (!expectedType.equals(type)) {
            throw new IllegalArgumentException("The parser for type '" + expectedType + "' was provided a map with type '" + type + '\'');
        }
    }

    public static String getTypeOrThrow(Map<String, ?> map) {
        Object type = map.get("type");
        if (type instanceof String) {
            String s = (String)type;
            if (s.isEmpty()) {
                throw new AdfException.MissingType();
            }
            return s;
        }
        throw new AdfException.MissingType();
    }

    public static <T> Optional<T> getAttr(Map<String, ?> map, String attr) {
        Map attrs = (Map)Cast.unsafeCast(map.get("attrs"));
        if (attrs == null) {
            return Optional.empty();
        }
        Object value = Cast.unsafeCast(attrs.get(attr));
        return Optional.ofNullable(value);
    }

    public static <T> Optional<T> getAttr(Map<String, ?> map, String attr, Class<T> requiredClass) {
        return ParserSupport.getAttr(map, attr).map(requiredClass::cast);
    }

    public static Optional<Integer> getAttrInt(Map<String, ?> map, String attr) {
        return ParserSupport.getAttr(map, attr).map(Number.class::cast).map(value -> ParserSupport.asInt(value, attr));
    }

    public static Optional<Double> getAttrDouble(Map<String, ?> map, String attr) {
        return ParserSupport.getAttr(map, attr).map(Number.class::cast).map(Number::doubleValue);
    }

    public static Optional<Number> getAttrNumber(Map<String, ?> map, String attr) {
        return ParserSupport.getAttr(map, attr, Number.class).map(ParserSupport::optimizeNumber);
    }

    public static String getAttrNonEmpty(Map<String, ?> map, String attr) {
        String s = (String)ParserSupport.getAttrOrThrow(map, attr);
        if (s.isEmpty()) {
            throw new AdfException.EmptyProperty(attr);
        }
        return s;
    }

    public static int asInt(Number value, String attrKey) {
        int x = value.intValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return x;
        }
        if (value instanceof Long ? (long)x == value.longValue() : (value instanceof Double || value instanceof Float) && (double)x == value.doubleValue()) {
            return x;
        }
        throw new AdfException.ValueTypeMismatch(attrKey, "int", value.getClass().getSimpleName());
    }

    public static int getAttrIntOrThrow(Map<String, ?> map, String attr) {
        return ParserSupport.asInt((Number)ParserSupport.getAttrOrThrow(map, attr), attr);
    }

    public static Number getAttrNumberOrThrow(Map<String, ?> map, String attr) {
        return ParserSupport.optimizeNumber(ParserSupport.getAttrOrThrow(map, attr, Number.class));
    }

    public static <T> T getAttrOrThrow(Map<String, ?> map, String attr) {
        Optional<T> value = ParserSupport.getAttr(map, attr);
        return value.orElseThrow(() -> new AdfException.MissingProperty(attr));
    }

    public static <T> T getAttrOrThrow(Map<String, ?> map, String attr, Class<T> requiredClass) {
        Optional<T> value = ParserSupport.getAttr(map, attr, requiredClass);
        return value.orElseThrow(() -> new AdfException.MissingProperty(attr));
    }

    private static Number optimizeNumber(Number num) {
        if (num instanceof Double) {
            long longValue = num.longValue();
            if (num.doubleValue() != (double)longValue) {
                return num;
            }
            num = longValue;
        }
        if (num instanceof Long) {
            int intValue = num.intValue();
            if (num.longValue() == (long)intValue) {
                return intValue;
            }
        }
        return num;
    }

    public static URL parseUrl(String url, String attrKey) {
        Objects.requireNonNull(url, "url");
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new AdfException.InvalidURL(attrKey, url, e);
        }
    }
}

