/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Alignment;
import com.atlassian.adf.model.mark.Indentation;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class Paragraph
extends AbstractContentNode<Paragraph, InlineContent>
implements Marked<Paragraph, PositionMark>,
DocContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static Factory<Paragraph> FACTORY = new Factory<Paragraph>("paragraph", Paragraph.class, Paragraph::parse);
    private final MarkHolder<PositionMark> marks = MarkHolder.limit(1);

    private Paragraph() {
    }

    public static Paragraph p() {
        return new Paragraph();
    }

    public static Paragraph p(String content) {
        return Paragraph.p((InlineContent)Text.text(content));
    }

    public static Paragraph p(String ... content) {
        return Paragraph.p(Arrays.stream(content).map(Text::text));
    }

    public static Paragraph p(InlineContent content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(InlineContent ... content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(Iterable<? extends InlineContent> content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(Stream<? extends InlineContent> content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph paragraph() {
        return new Paragraph();
    }

    public static Paragraph paragraph(String content) {
        return Paragraph.paragraph((InlineContent)Text.text(content));
    }

    public static Paragraph paragraph(String ... content) {
        return Paragraph.paragraph(Arrays.stream(content).map(Text::text));
    }

    public static Paragraph paragraph(InlineContent content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(InlineContent ... content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(Iterable<? extends InlineContent> content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(Stream<? extends InlineContent> content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public Paragraph text(String content) {
        return (Paragraph)this.content(Text.text(content));
    }

    public Paragraph text(String content, TextMark mark) {
        return (Paragraph)this.content(Text.text(content, mark));
    }

    public Paragraph text(String content, TextMark ... marks) {
        return (Paragraph)this.content(Text.text(content, marks));
    }

    public Paragraph text(String ... content) {
        return (Paragraph)this.content(Text.text(content));
    }

    @Override
    public Collection<PositionMark> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends PositionMark> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public Paragraph mark(PositionMark mark) {
        this.marks.add(mark);
        return this;
    }

    public Paragraph alignment(Alignment alignment) {
        return this.mark(alignment);
    }

    public Paragraph center() {
        return this.mark(Alignment.center());
    }

    public Paragraph end() {
        return this.mark(Alignment.end());
    }

    public Paragraph indentation(Indentation indentation) {
        return this.mark(indentation);
    }

    public Paragraph indentation(int level) {
        return this.mark(Indentation.indentation(level));
    }

    @Override
    public String elementType() {
        return "paragraph";
    }

    @Override
    public void validate() {
        super.validate();
        this.marks.validate();
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).let(this.marks::addToMap);
    }

    private static Paragraph parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "paragraph");
        Paragraph p = (Paragraph)Paragraph.p().parseOptionalContent(map, InlineContent.class);
        MarkParserSupport.parsePositionMark(map, p);
        return p;
    }

    void disableMarks(ContentNode<?, ? super Paragraph> parent) {
        this.marks.disable(parent.elementType());
    }

    void disableIndentation(ContentNode<?, ? super Paragraph> parent) {
        this.marks.rejectInstancesOf(Indentation.class, parent.elementType());
    }
}

