/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExtensionSettings {
    private String extensionKey;
    private String extensionType;
    @Nullable
    private Map<String, ?> parameters;
    @Nullable
    private String localId;
    @Nullable
    private String text;

    private ExtensionSettings(String extensionKey, String extensionType) {
        this.extensionKey = ExtensionSettings.validateExtensionKey(extensionKey);
        this.extensionType = ExtensionSettings.validateExtensionType(extensionType);
    }

    public static Partial.NeedsExtensionKey<ExtensionSettings> extensionSettings() {
        return ExtensionSettings.extensionSettings(Function.identity());
    }

    public static <T> Partial.NeedsExtensionKey<T> extensionSettings(Function<ExtensionSettings, T> constructor) {
        return new Partial.NeedsExtensionKey<T>(constructor);
    }

    public static ExtensionSettings extensionSettings(String extensionKey, String extensionType) {
        return new ExtensionSettings(extensionKey, extensionType);
    }

    public <T> T map(Function<ExtensionSettings, T> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return mapper.apply(this);
    }

    public ExtensionSettings let(Consumer<? super ExtensionSettings> effect) {
        effect.accept(this);
        return this;
    }

    public void extensionKey(String extensionKey) {
        this.extensionKey = ExtensionSettings.validateExtensionKey(extensionKey);
    }

    public void extensionType(String extensionType) {
        this.extensionType = ExtensionSettings.validateExtensionType(extensionType);
    }

    public void localId(@Nullable String localId) {
        this.localId = Element.nullOrNonEmpty(localId, "localId");
    }

    public void text(@Nullable String text) {
        this.text = text;
    }

    public void parameters(@Nullable Map<String, ?> parameters) {
        this.parameters = parameters != null ? FieldMap.immutableCopy(parameters) : null;
    }

    public String extensionKey() {
        return this.extensionKey;
    }

    public String extensionType() {
        return this.extensionType;
    }

    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    public Optional<Map<String, ?>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    FieldMap toExtensionAttrs() {
        return FieldMap.map().add("extensionKey", this.extensionKey).add("extensionType", this.extensionType).addIfPresent("localId", this.localId).addIfPresent("text", this.text).addIfPresent("parameters", this.parameters);
    }

    static ExtensionSettings parse(Map<String, ?> map) {
        String extensionKey = ParserSupport.getAttrNonEmpty(map, "extensionKey");
        String extensionType = ParserSupport.getAttrNonEmpty(map, "extensionType");
        ExtensionSettings data = new ExtensionSettings(extensionKey, extensionType);
        ParserSupport.getAttr(map, "localId", String.class).ifPresent(data::localId);
        ParserSupport.getAttr(map, "text", String.class).ifPresent(data::text);
        ParserSupport.getAttr(map, "parameters", Map.class).ifPresent(parameters -> data.parameters((Map)Cast.unsafeCast(parameters)));
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionSettings that = (ExtensionSettings)o;
        return this.extensionKey.equals(that.extensionKey) && this.extensionType.equals(that.extensionType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.localId, that.localId) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.extensionKey, this.extensionType, this.parameters, this.localId, this.text);
    }

    private static String validateExtensionKey(String extensionKey) {
        return Element.nonEmpty(extensionKey, "extensionKey");
    }

    private static String validateExtensionType(String extensionType) {
        return Element.nonEmpty(extensionType, "extensionType");
    }

    public static enum Layout {
        WIDE("wide"),
        FULL_WIDTH("full-width"),
        DEFAULT("default");

        static final EnumParser<Layout> PARSER;
        private final String layout;

        private Layout(String layout) {
            this.layout = layout;
        }

        public String layout() {
            return this.layout;
        }

        static {
            PARSER = new EnumParser<Layout>(Layout.class, Layout::layout);
        }
    }

    public static interface Partial {

        public static class NeedsExtensionType<T> {
            private final Function<ExtensionSettings, T> constructor;
            private final String extensionKey;

            NeedsExtensionType(Function<ExtensionSettings, T> constructor, String extensionKey) {
                this.constructor = Objects.requireNonNull(constructor, "constructor");
                this.extensionKey = Element.nonEmpty(extensionKey, "extensionKey");
            }

            public T extensionType(String extensionType) {
                ExtensionSettings settings = new ExtensionSettings(this.extensionKey, extensionType);
                return this.constructor.apply(settings);
            }
        }

        public static class NeedsExtensionKey<T> {
            private final Function<ExtensionSettings, T> constructor;

            NeedsExtensionKey(Function<ExtensionSettings, T> constructor) {
                this.constructor = Objects.requireNonNull(constructor, "constructor");
            }

            public NeedsExtensionType<T> extensionKey(String extensionKey) {
                return new NeedsExtensionType<T>(this.constructor, extensionKey);
            }
        }
    }
}

