/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class Emoji
extends AbstractNode
implements CaptionContent,
InlineContent {
    static Factory<Emoji> FACTORY = new Factory<Emoji>("emoji", Emoji.class, Emoji::parse);
    private String shortName;
    @Nullable
    private String id;
    @Nullable
    private String text;

    private Emoji(String shortName) {
        this.shortName = Emoji.validateShortName(shortName);
    }

    public static Partial.NeedsShortName emoji() {
        return new Partial.NeedsShortName();
    }

    public static Emoji emoji(String shortName) {
        return new Emoji(shortName);
    }

    public Emoji shortName(String shortName) {
        this.shortName = Emoji.validateShortName(shortName);
        return this;
    }

    public String shortName() {
        return this.shortName;
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public Emoji id(String id) {
        this.id = id;
        return this;
    }

    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    public Emoji text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        return this.shortName.equals(emoji.shortName) && Objects.equals(this.id, emoji.id) && Objects.equals(this.text, emoji.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.shortName, this.text);
    }

    @Override
    public String elementType() {
        return "emoji";
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("shortName", this.shortName).addIfPresent("id", this.id).addIfPresent("text", this.text));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Emoji{shortName=").append(this.shortName);
        if (this.id != null) {
            sb.append(", id=").append(this.id);
        }
        if (this.text != null) {
            sb.append(", text=").append(this.text);
        }
        return sb.append('}').toString();
    }

    private static Emoji parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "emoji");
        Emoji emoji = Emoji.emoji(ParserSupport.getAttrOrThrow(map, "shortName", String.class));
        ParserSupport.getAttr(map, "id", String.class).ifPresent(emoji::id);
        ParserSupport.getAttr(map, "text", String.class).ifPresent(emoji::text);
        return emoji;
    }

    private static String validateShortName(String shortName) {
        Objects.requireNonNull(shortName, "shortName");
        return Element.nonEmpty(shortName, "shortName");
    }

    public static interface Partial {

        public static class NeedsShortName {
            NeedsShortName() {
            }

            public Emoji shortName(String shortName) {
                return new Emoji(shortName);
            }
        }
    }
}

