/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.DocException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class Doc
extends AbstractContentNode<Doc, DocContent> {
    static Factory<Doc> FACTORY = new Factory<Doc>("doc", Doc.class, Doc::parse);
    private static final Version DEFAULT_VERSION = Version.V1;
    private Version version = DEFAULT_VERSION;

    private Doc() {
    }

    public static Doc doc() {
        return new Doc();
    }

    public static Doc doc(DocContent content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(DocContent ... content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Iterable<? extends DocContent> content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Stream<? extends DocContent> content) {
        return (Doc)Doc.doc().content(content);
    }

    public static Doc doc(Version version) {
        return Doc.doc().version(version);
    }

    public static Doc doc(Version version, DocContent content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, DocContent ... content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, Iterable<? extends DocContent> content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public static Doc doc(Version version, Stream<? extends DocContent> content) {
        return (Doc)Doc.doc(version).content(content);
    }

    public Doc version(Version version) {
        this.version = Objects.requireNonNull(version, "version");
        return this;
    }

    public Version version() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.version == ((Doc)o).version;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.version.hashCode();
    }

    @Override
    public String elementType() {
        return "doc";
    }

    @Override
    protected void validateContentNodeForAppend(DocContent node) {
        super.validateContentNodeForAppend(node);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("version", this.version.value()).add("content", this.contentFieldMaps());
    }

    @Override
    public String toString() {
        return this.toMap().toString();
    }

    public static Doc parse(Map<String, ?> map) {
        return AdfException.frame("doc", () -> {
            String type = ParserSupport.getTypeOrThrow(map);
            if (!"doc".equals(type)) {
                throw new DocException.InvalidTopLevel(type);
            }
            Version version = Version.parse((Number)ParserSupport.getOrThrow(map, "version"));
            return (Doc)Doc.doc(version).parseRequiredContentAllowEmpty(map, DocContent.class);
        });
    }

    public static enum Version {
        V1(1);

        private final int value;

        private Version(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        static Version parse(Number version) {
            if (version instanceof Integer) {
                return Version.parse(version.intValue());
            }
            if (version instanceof Long) {
                long value = version.longValue();
                if (value <= 0L || value > Integer.MAX_VALUE) {
                    throw new DocException.UnsupportedVersion(version);
                }
                return Version.parse(version.intValue());
            }
            throw new DocException.UnsupportedVersion(version);
        }

        static Version parse(int version) {
            return Arrays.stream(Version.values()).filter(v -> v.value == version).findAny().orElseThrow(() -> new DocException.UnsupportedVersion(version));
        }
    }
}

