/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.BlockParser;
import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.InlineContent;
import java.util.stream.Stream;
import org.jsoup.nodes.Element;

class HeadingParser
implements ElementParser {
    static final HeadingParser H1 = new HeadingParser(1);
    static final HeadingParser H2 = new HeadingParser(2);
    static final HeadingParser H3 = new HeadingParser(3);
    static final HeadingParser H4 = new HeadingParser(4);
    static final HeadingParser H5 = new HeadingParser(5);
    static final HeadingParser H6 = new HeadingParser(6);
    private final int level;

    private HeadingParser(int level) {
        this.level = level;
    }

    @Override
    public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
        BlockParser<Heading, InlineContent> delegate = new BlockParser<Heading, InlineContent>(htmlParser, () -> Heading.heading((int)this.level)){

            @Override
            void addChildNode(Node child) {
                if (child instanceof Paragraph) {
                    Paragraph p = (Paragraph)child;
                    p.content().forEach(x$0 -> super.addChildNode((Node)x$0));
                } else {
                    super.addChildNode(child);
                }
            }
        };
        return delegate.parse(html);
    }
}

