/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.AddressParser;
import com.atlassian.adf.html.parser.AnchorParser;
import com.atlassian.adf.html.parser.BlockParser;
import com.atlassian.adf.html.parser.ChildrenParser;
import com.atlassian.adf.html.parser.CodeBlockParser;
import com.atlassian.adf.html.parser.DiscardParser;
import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.FallbackParser;
import com.atlassian.adf.html.parser.HardBreakParser;
import com.atlassian.adf.html.parser.HeadingParser;
import com.atlassian.adf.html.parser.ListItemParser;
import com.atlassian.adf.html.parser.OrderedListParser;
import com.atlassian.adf.html.parser.ParagraphParser;
import com.atlassian.adf.html.parser.RuleParser;
import com.atlassian.adf.html.parser.TextMarkParser;
import com.atlassian.adf.model.node.Blockquote;
import com.atlassian.adf.model.node.BulletList;
import com.atlassian.adf.model.node.Panel;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.Table;
import com.atlassian.adf.model.node.TableCell;
import com.atlassian.adf.model.node.TableHeader;
import com.atlassian.adf.model.node.TableRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ElementResolver {
    private static final Map<String, ElementParser> LOOKUP = Init.lookupMap();

    ElementResolver() {
    }

    static ElementParser resolveParser(String name) {
        return LOOKUP.getOrDefault(name, FallbackParser.INSTANCE);
    }

    private static class Init {
        private static final Map<String, ElementParser> MAP = new HashMap<String, ElementParser>();

        private Init() {
        }

        static void add(String name, ElementParser parser) {
            MAP.put(name, parser);
        }

        static Map<String, ElementParser> lookupMap() {
            return Collections.unmodifiableMap(MAP);
        }

        static {
            Init.add("a", AnchorParser.INSTANCE);
            Init.add("address", AddressParser.INSTANCE);
            Init.add("article", ChildrenParser.INSTANCE);
            Init.add("b", TextMarkParser.STRONG);
            Init.add("blockquote", BlockParser.blockFactory(Blockquote::bq));
            Init.add("body", ChildrenParser.INSTANCE);
            Init.add("br", HardBreakParser.INSTANCE);
            Init.add("cite", TextMarkParser.EM);
            Init.add("code", TextMarkParser.CODE);
            Init.add("dd", ChildrenParser.INSTANCE);
            Init.add("del", TextMarkParser.STRIKE);
            Init.add("details", ChildrenParser.INSTANCE);
            Init.add("div", BlockParser.blockFactory(Paragraph::p));
            Init.add("dl", ChildrenParser.INSTANCE);
            Init.add("dt", ChildrenParser.INSTANCE);
            Init.add("em", TextMarkParser.EM);
            Init.add("footer", ChildrenParser.INSTANCE);
            Init.add("form", DiscardParser.INSTANCE);
            Init.add("h1", HeadingParser.H1);
            Init.add("h2", HeadingParser.H2);
            Init.add("h3", HeadingParser.H3);
            Init.add("h4", HeadingParser.H4);
            Init.add("h5", HeadingParser.H5);
            Init.add("h6", HeadingParser.H6);
            Init.add("head", DiscardParser.INSTANCE);
            Init.add("header", ChildrenParser.INSTANCE);
            Init.add("hr", RuleParser.INSTANCE);
            Init.add("i", TextMarkParser.EM);
            Init.add("ins", TextMarkParser.UNDERLINE);
            Init.add("li", ListItemParser.INSTANCE);
            Init.add("main", ChildrenParser.INSTANCE);
            Init.add("nav", ChildrenParser.INSTANCE);
            Init.add("ol", OrderedListParser.INSTANCE);
            Init.add("p", ParagraphParser.INSTANCE);
            Init.add("pre", CodeBlockParser.INSTANCE);
            Init.add("s", TextMarkParser.STRIKE);
            Init.add("section", ChildrenParser.INSTANCE);
            Init.add("span", ChildrenParser.INSTANCE);
            Init.add("strike", TextMarkParser.STRIKE);
            Init.add("strong", TextMarkParser.STRONG);
            Init.add("sub", TextMarkParser.SUB);
            Init.add("summary", ChildrenParser.INSTANCE);
            Init.add("sup", TextMarkParser.SUP);
            Init.add("table", BlockParser.blockFactory(Table::table));
            Init.add("tbody", ChildrenParser.INSTANCE);
            Init.add("td", BlockParser.blockFactory(TableCell::td));
            Init.add("textarea", BlockParser.blockFactory(() -> Panel.panel().info()));
            Init.add("tfoot", ChildrenParser.INSTANCE);
            Init.add("th", BlockParser.blockFactory(TableHeader::th));
            Init.add("thead", ChildrenParser.INSTANCE);
            Init.add("tr", BlockParser.blockFactory(TableRow::tr));
            Init.add("tt", TextMarkParser.CODE_WITHOUT_LANG);
            Init.add("u", TextMarkParser.UNDERLINE);
            Init.add("ul", BlockParser.blockFactory(BulletList::ul));
        }
    }
}

