/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jsoup.nodes.Element;

class AnchorParser
implements ElementParser {
    static final AnchorParser INSTANCE = new AnchorParser();

    private AnchorParser() {
    }

    @Override
    public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
        Stream<? extends Node> contents = htmlParser.parseChildren((org.jsoup.nodes.Node)html);
        String url = html.attributes().get("href");
        if (url.isEmpty()) {
            return contents;
        }
        try {
            String cleaned = ParserSupport.cleanUri((String)url, (String)"href");
            URI parsed = new URI(cleaned);
            if (!parsed.isAbsolute()) {
                return contents;
            }
            Link link = Link.link((String)url);
            String title = html.attributes().get("title");
            if (!title.isEmpty()) {
                link.title(title);
            }
            return AnchorParser.decorateWithLink(link, contents);
        }
        catch (AdfException.InvalidURI | URISyntaxException ignore) {
            return contents;
        }
    }

    private static Stream<? extends Node> decorateWithLink(Link link, Stream<? extends Node> nodes) {
        boolean[] linked = new boolean[]{false};
        ArrayList<Text> list = new ArrayList<Text>();
        nodes.forEach(node -> {
            Marked marked;
            if (node instanceof Text) {
                Text text = (Text)node;
                if (text.markIfAllowed((TextMark)link.copy())) {
                    linked[0] = true;
                }
            } else if (node instanceof Marked && (marked = (Marked)Cast.unsafeCast((Object)node)).markClass().isInstance(link)) {
                Marked linkable = (Marked)Cast.unsafeCast((Object)marked);
                if (linkable.mark(MarkKey.link()).isEmpty()) {
                    linkable.mark((Mark)link.copy());
                }
                linked[0] = true;
            }
            list.add((Text)node);
        });
        if (!linked[0]) {
            list.add(Text.text((String)link.href(), (TextMark[])new TextMark[]{link}));
        }
        return list.stream();
    }
}

