/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.test;

import com.atlassian.activeobjects.internal.EntityManagedActiveObjects;
import com.atlassian.activeobjects.internal.TransactionManager;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import net.java.ao.ActiveObjectsException;
import net.java.ao.EntityManager;
import net.java.ao.Transaction;

public final class TestActiveObjects
extends EntityManagedActiveObjects {
    private static final Map<String, DatabaseType> DATABASE_PRODUCT_TO_TYPE_MAP = ImmutableMap.builder().put((Object)"H2", (Object)DatabaseType.H2).put((Object)"HSQL Database Engine", (Object)DatabaseType.HSQL).put((Object)"MySQL", (Object)DatabaseType.MYSQL).put((Object)"PostgreSQL", (Object)DatabaseType.POSTGRESQL).put((Object)"Oracle", (Object)DatabaseType.ORACLE).put((Object)"Microsoft SQL Server", (Object)DatabaseType.MS_SQL).put((Object)"DB2", (Object)DatabaseType.DB2).build();

    public TestActiveObjects(final EntityManager entityManager) {
        super(entityManager, new TransactionManager(){

            public <T> T doInTransaction(final TransactionCallback<T> callback) {
                try {
                    return (T)new Transaction<T>(entityManager){

                        public T run() {
                            return callback.doInTransaction();
                        }
                    }.execute();
                }
                catch (SQLException e) {
                    throw new ActiveObjectsException((Throwable)e);
                }
            }
        }, TestActiveObjects.findDatabaseType(entityManager));
    }

    private static DatabaseType findDatabaseType(EntityManager entityManager) {
        Connection connection = null;
        try {
            connection = entityManager.getProvider().getConnection();
            String dbName = connection.getMetaData().getDatabaseProductName();
            for (Map.Entry<String, DatabaseType> entry : DATABASE_PRODUCT_TO_TYPE_MAP.entrySet()) {
                if (!dbName.startsWith(entry.getKey())) continue;
                DatabaseType databaseType = entry.getValue();
                return databaseType;
            }
        }
        catch (SQLException e) {
            throw new ActiveObjectsException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new ActiveObjectsException((Throwable)e);
                }
            }
        }
        return DatabaseType.UNKNOWN;
    }
}

