/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.spi;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

public final class ConnectionHandler
implements InvocationHandler {
    private final Connection delegate;
    private final Closeable closeable;

    public ConnectionHandler(Connection delegate, Closeable closeable) {
        this.delegate = (Connection)Preconditions.checkNotNull((Object)delegate);
        this.closeable = (Closeable)Preconditions.checkNotNull((Object)closeable);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ConnectionHandler.isCloseMethod(method)) {
            this.closeable.close();
            return Void.TYPE;
        }
        return this.delegate(method, args);
    }

    private Object delegate(Method method, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return method.invoke((Object)this.delegate, args);
    }

    public static Connection newInstance(Connection c) {
        return ConnectionHandler.newInstance(c, new Closeable(){

            @Override
            public void close() throws SQLException {
            }
        });
    }

    public static Connection newInstance(Connection c, Closeable closeable) {
        return (Connection)Proxy.newProxyInstance(ConnectionHandler.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler(c, closeable));
    }

    private static boolean isCloseMethod(Method method) {
        return method.getName().equals("close") && method.getParameterTypes().length == 0;
    }

    public static interface Closeable {
        public void close() throws SQLException;
    }
}

