/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.dbexporter;

import com.atlassian.dbexporter.Column;
import com.atlassian.dbexporter.ForeignKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Table {
    private final String name;
    private final List<Column> columns;
    private final Collection<ForeignKey> foreignKeys;

    public Table(String name, List<Column> columns, Collection<ForeignKey> foreignKeys) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.columns = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(columns)));
        this.foreignKeys = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(foreignKeys)));
    }

    public String getName() {
        return this.name;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public Collection<ForeignKey> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys);
    }
}

