/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.confluence.transaction;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.confluence.core.SynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class ConfluenceAOSynchronisationManager
implements TransactionSynchronisationManager {
    private SynchronizationManager synchronisationManager;

    public ConfluenceAOSynchronisationManager(SynchronizationManager synchManager) {
        this.synchronisationManager = synchManager;
    }

    @Override
    public boolean runOnRollBack(final Runnable callback) {
        if (this.synchronisationManager.isTransactionActive()) {
            this.synchronisationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (status == 1) {
                        callback.run();
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean runOnSuccessfulCommit(Runnable callback) {
        if (this.synchronisationManager.isTransactionActive()) {
            this.synchronisationManager.runOnSuccessfulCommit(callback);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActiveSynchronisedTransaction() {
        return this.synchronisationManager.isTransactionActive();
    }
}

