/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr;

import com.asprise.ocr.OcrException;
import com.asprise.ocr.sample.FrameOcrSample;
import com.asprise.ocr.util.OcrLibHelper;
import com.asprise.ocr.util.StringUtils;
import com.asprise.ocr.util.Utils;
import java.awt.GraphicsEnvironment;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Ocr {
    public static final String SPEED_FASTEST = "fastest";
    public static final String SPEED_FAST = "fast";
    public static final String SPEED_SLOW = "slow";
    public static final String RECOGNIZE_TYPE_TEXT = "text";
    public static final String RECOGNIZE_TYPE_BARCODE = "barcode";
    public static final String RECOGNIZE_TYPE_ALL = "all";
    public static final String OUTPUT_FORMAT_PLAINTEXT = "text";
    public static final String OUTPUT_FORMAT_XML = "xml";
    public static final String OUTPUT_FORMAT_PDF = "pdf";
    public static final String OUTPUT_FORMAT_RTF = "rtf";
    public static final String LANGUAGE_ENG = "eng";
    public static final String LANGUAGE_SPA = "spa";
    public static final String LANGUAGE_POR = "por";
    public static final String LANGUAGE_DEU = "deu";
    public static final String LANGUAGE_FRA = "fra";
    public static final String START_PROP_DICT_SKIP_BUILT_IN_DEFAULT = "START_PROP_DICT_SKIP_BUILT_IN_DEFAULT";
    public static final String START_PROP_DICT_SKIP_BUILT_IN_ALL = "START_PROP_DICT_SKIP_BUILT_IN_ALL";
    public static final String START_PROP_DICT_CUSTOM_DICT_FILE = "START_PROP_DICT_CUSTOM_DICT_FILE";
    public static final String START_PROP_DICT_CUSTOM_TEMPLATES_FILE = "START_PROP_DICT_CUSTOM_TEMPLATES_FILE";
    public static final String PROP_DICT_DICT_IMPORTANCE = "PROP_DICT_DICT_IMPORTANCE";
    public static final String PROP_PAGE_TYPE = "PROP_PAGE_TYPE";
    public static final String PROP_PAGE_TYPE_AUTO = "auto";
    public static final String PROP_PAGE_TYPE_SINGLE_BLOCK = "single_block";
    public static final String PROP_PAGE_TYPE_SINGLE_COLUMN = "single_column";
    public static final String PROP_PAGE_TYPE_SINGLE_LINE = "single_line";
    public static final String PROP_PAGE_TYPE_SINGLE_WORD = "single_word";
    public static final String PROP_PAGE_TYPE_SINGLE_CHAR = "single_char";
    public static final String PROP_PAGE_TYPE_SCATTERED = "scattered";
    public static final String PROP_LIMIT_TO_CHARSET = "PROP_LIMIT_TO_CHARSET";
    public static final String PROP_OUTPUT_SEPARATE_WORDS = "PROP_OUTPUT_SEPARATE_WORDS";
    public static final String PROP_INPUT_PDF_DPI = "PROP_INPUT_PDF_DPI";
    public static final String PROP_IMG_PREPROCESS_TYPE = "PROP_IMG_PREPROCESS_TYPE";
    public static final String PROP_IMG_PREPROCESS_TYPE_DEFAULT = "default";
    public static final String PROP_IMG_PREPROCESS_TYPE_DEFAULT_WITH_ORIENTATION_DETECTION = "default_with_orientation_detection";
    public static final String PROP_IMG_PREPROCESS_TYPE_CUSTOM = "custom";
    public static final String PROP_IMG_PREPROCESS_CUSTOM_CMDS = "PROP_IMG_PREPROCESS_CUSTOM_CMDS";
    public static final String PROP_TABLE_SKIP_DETECTION = "PROP_TABLE_SKIP_DETECTION";
    public static final String PROP_TABLE_MIN_SIDE_LENGTH = "PROP_TABLE_MIN_SIDE_LENGTH";
    public static final String PROP_SAVE_INTERMEDIATE_IMAGES_TO_DIR = "PROP_SAVE_INTERMEDIATE_IMAGES_TO_DIR";
    public static final String PROP_PDF_OUTPUT_FILE = "PROP_PDF_OUTPUT_FILE";
    public static final String PROP_PDF_OUTPUT_IMAGE_DPI = "PROP_PDF_OUTPUT_IMAGE_DPI";
    public static final String PROP_PDF_OUTPUT_FONT = "PROP_PDF_OUTPUT_FONT";
    public static final String PROP_PDF_OUTPUT_TEXT_VISIBLE = "PROP_PDF_OUTPUT_TEXT_VISIBLE";
    public static final String PROP_PDF_OUTPUT_IMAGE_FORCE_BW = "PROP_PDF_OUTPUT_IMAGE_FORCE_BW";
    public static final String PROP_PDF_OUTPUT_CONF_THRESHOLD = "PROP_PDF_OUTPUT_CONF_THRESHOLD";
    public static final String PROP_PDF_OUTPUT_RETURN_TEXT = "PROP_PDF_OUTPUT_RETURN_TEXT";
    public static final String PROP_PDF_OUTPUT_RETURN_TEXT_FORMAT_PLAINTEXT = "text";
    public static final String PROP_PDF_OUTPUT_RETURN_TEXT_FORMAT_XML = "xml";
    public static final String PROP_PDF_OUTPUT_PDFA = "PROP_PDF_OUTPUT_PDFA";
    public static final String PROP_PDF_OUTPUT_PDFA_FONT_FILE = "PROP_PDF_OUTPUT_PDFA_FONT_FILE";
    public static final String PROP_RTF_OUTPUT_FILE = "PROP_RTF_OUTPUT_FILE";
    public static final String PROP_RTF_PAPER_SIZE = "PROP_RTF_PAPER_SIZE";
    public static final String PROP_RTF_OUTPUT_RETURN_TEXT = "PROP_RTF_OUTPUT_RETURN_TEXT";
    public static final String PROP_RTF_OUTPUT_RETURN_TEXT_FORMAT_PLAINTEXT = "text";
    public static final String PROP_RTF_OUTPUT_RETURN_TEXT_FORMAT_XML = "xml";
    public static String CONFIG_PROP_SEPARATOR = "|";
    public static String CONFIG_PROP_KEY_VALUE_SEPARATOR = "=";
    public static final int PAGES_ALL = -1;
    private long handle;
    volatile Thread threadDoingOCR;

    public static String getLibraryVersion() {
        return Ocr.doGetVersion();
    }

    public static String getLibraryVersion(boolean verbose) {
        return Ocr.doGetVersion() + System.getProperty("line.separator") + Ocr.doGetBuildInfo();
    }

    public static boolean isSetupRequired() {
        return Ocr.doSetup(true) != 1;
    }

    public static void setUp() {
        int result = Ocr.doSetup(false);
        if (result != 1) {
            throw new OcrException("Failed to set up OCR. Error code: " + result);
        }
    }

    public static String[] listSupportedLanguages() {
        String s = Ocr.doListSupportedLangs();
        if (s == null) {
            return new String[0];
        }
        Object[] langs = StringUtils.split(s, ",");
        if (langs != null && langs.length > 0) {
            Arrays.sort(langs);
        }
        return langs;
    }

    public void startEngine(String lang, String speed, Object ... startPropSpec) {
        if (this.handle > 0L) {
            return;
        }
        if (StringUtils.isEmpty(lang)) {
            throw new IllegalArgumentException("Language is required.");
        }
        if (!(SPEED_FASTEST.equals(speed) || SPEED_FAST.equals(speed) || SPEED_SLOW.equals(speed))) {
            throw new IllegalArgumentException("Invalid speed: " + speed);
        }
        Properties props = Ocr.readProperties(startPropSpec);
        String s = this.doStart(lang, speed, Ocr.propsToString(props), CONFIG_PROP_SEPARATOR, CONFIG_PROP_KEY_VALUE_SEPARATOR);
        if (s != null) {
            throw new OcrException(s);
        }
    }

    public void stopEngine() {
        if (this.handle > 0L) {
            this.doStop();
        }
    }

    public boolean isEngineRunning() {
        return this.handle > 0L;
    }

    public String recognize(URL[] sources, String recognizeType, String outputFormat, Object ... propSpec) {
        File tmpDir = Utils.getTempFolderWritable();
        if (tmpDir == null) {
            throw new OcrException("Unable to find temporary dir");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; sources != null && i < sources.length; ++i) {
            File tmpFile = new File(tmpDir, "" + System.currentTimeMillis() + "-" + StringUtils.randomAlphanumeric(3));
            try {
                Utils.saveToFile(sources[i], tmpFile);
            }
            catch (Throwable e) {
                throw new OcrException(e);
            }
            files.add(tmpFile);
        }
        String s = this.recognize(files.toArray(new File[0]), recognizeType, outputFormat, propSpec);
        for (File file : files) {
            file.delete();
        }
        return s;
    }

    public String recognize(File[] files, String recognizeType, String outputFormat, Object ... propSpec) {
        String fs = Ocr.filesToString(files);
        if (StringUtils.isEmpty(fs)) {
            return null;
        }
        String s = this.recognize(fs, -1, -1, -1, -1, -1, recognizeType, outputFormat, propSpec);
        return s;
    }

    public String recognize(RenderedImage img, String recognizeType, String outputFormat, Object ... propSpec) {
        if (img == null) {
            throw new IllegalArgumentException("img is null");
        }
        File fileImageTmp = null;
        try {
            fileImageTmp = File.createTempFile("ocr", ".png");
            ImageIO.write(img, "png", fileImageTmp);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to save image to " + fileImageTmp, t);
        }
        String s = this.recognize(fileImageTmp.getAbsolutePath(), -1, -1, -1, -1, -1, recognizeType, outputFormat, propSpec);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recognize(String files, int pageIndex, int startX, int startY, int width, int height, String recognizeType, String outputFormat, Object ... propSpec) {
        if (this.threadDoingOCR != null) {
            throw new OcrException("Currently " + this.threadDoingOCR + " is using this OCR engine. Please create multiple OCR engine instances for multi-threading. ");
        }
        Properties props = Ocr.readProperties(propSpec);
        try {
            this.threadDoingOCR = Thread.currentThread();
            if (StringUtils.isEmpty(files)) {
                throw new IllegalArgumentException("files can not be empty!");
            }
            String pdfOutputFile = props.getProperty(PROP_PDF_OUTPUT_FILE);
            if (OUTPUT_FORMAT_PDF.equals(outputFormat) && StringUtils.isEmpty(pdfOutputFile)) {
                throw new IllegalArgumentException("You must specify PDF output through property named: PROP_PDF_OUTPUT_FILE");
            }
            String string = this.doRecognize(files, pageIndex, startX, startY, width, height, recognizeType, outputFormat, Ocr.propsToString(props), CONFIG_PROP_SEPARATOR, CONFIG_PROP_KEY_VALUE_SEPARATOR);
            return string;
        }
        finally {
            this.threadDoingOCR = null;
        }
    }

    protected static Properties readProperties(Object[] propSpec) {
        Object value;
        Properties props = new Properties();
        if (propSpec != null && propSpec.length != 0 && (propSpec.length != 1 || propSpec[0] != null)) {
            if (propSpec.length == 1 && propSpec[0] instanceof String) {
                props = Ocr.stringToProps((String)propSpec[0]);
            } else if (propSpec.length > 0 && propSpec[0] instanceof Properties) {
                props = (Properties)propSpec[0];
            } else {
                if (propSpec.length % 2 == 1) {
                    throw new IllegalArgumentException("Property specification must come in pairs: " + Arrays.toString(propSpec));
                }
                for (int p = 0; p < propSpec.length; p += 2) {
                    Object key = propSpec[p];
                    value = propSpec[p + 1];
                    String valueAsString = null;
                    valueAsString = value == null ? "" : (value instanceof File ? ((File)value).getAbsolutePath() : String.valueOf(value));
                    props.setProperty(String.valueOf(key), valueAsString);
                }
            }
        }
        for (Object key : props.keySet()) {
            value = props.get(key);
            if (key == null || value == null) {
                throw new IllegalArgumentException("Neither key or value of a property can be null: " + key + "=" + value);
            }
            if (key.toString().contains(CONFIG_PROP_KEY_VALUE_SEPARATOR)) {
                throw new IllegalArgumentException("Please change CONFIG_PROP_KEY_VALUE_SEPARATOR to a different value as \"" + key + "\" contains \"" + CONFIG_PROP_KEY_VALUE_SEPARATOR + "\"");
            }
            if (!value.toString().contains(CONFIG_PROP_SEPARATOR)) continue;
            throw new IllegalArgumentException("Please change CONFIG_PROP_SEPARATOR to a different value as \"" + value + "\" contains \"" + CONFIG_PROP_SEPARATOR + "\"");
        }
        return props;
    }

    private static Properties stringToProps(String spec) {
        Properties props = new Properties();
        StringTokenizer stProps = new StringTokenizer(spec, CONFIG_PROP_SEPARATOR);
        while (stProps.hasMoreTokens()) {
            StringTokenizer stKeyVal;
            String tokenProp = stProps.nextToken();
            if (tokenProp == null || tokenProp.trim().length() == 0 || (stKeyVal = new StringTokenizer(tokenProp, CONFIG_PROP_KEY_VALUE_SEPARATOR)).countTokens() != 2) continue;
            props.setProperty(stKeyVal.nextToken().trim(), stKeyVal.nextToken().trim());
        }
        return props;
    }

    public static String propsToString(Properties props) {
        StringBuilder sb = new StringBuilder();
        for (Object key : props.keySet()) {
            if (sb.length() > 0) {
                sb.append(CONFIG_PROP_SEPARATOR);
            }
            sb.append(String.valueOf(key));
            sb.append(CONFIG_PROP_KEY_VALUE_SEPARATOR);
            sb.append(String.valueOf(props.get(key)));
        }
        return sb.toString();
    }

    private static String filesToString(File[] files) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) {
                System.err.println("File does not exist: " + file.getAbsolutePath());
                continue;
            }
            if (file.getAbsolutePath().contains(",")) {
                throw new OcrException("Comma is not allowed in file name: " + file.getAbsolutePath());
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    private static native String doGetVersion();

    private static native String doGetBuildInfo();

    private static native int doSetup(boolean var0);

    private static native String doListSupportedLangs();

    private native String doStart(String var1, String var2, String var3, String var4, String var5);

    private native String doRecognize(String var1, int var2, int var3, int var4, int var5, int var6, String var7, String var8, String var9, String var10, String var11);

    private native String doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean saveAocrXslToDir(File dir, boolean overwrite) {
        boolean bl;
        OutputStream outputStream;
        InputStream inputStream;
        block31: {
            File file;
            block29: {
                boolean bl2;
                block30: {
                    if (dir == null) {
                        throw new IllegalArgumentException();
                    }
                    file = new File(dir, "aocr.xsl");
                    if (file.exists() && !overwrite) {
                        return false;
                    }
                    file.getParentFile().mkdirs();
                    inputStream = null;
                    outputStream = null;
                    inputStream = Ocr.class.getResourceAsStream("/aocr.xsl");
                    if (inputStream != null) break block29;
                    bl2 = false;
                    if (outputStream == null) break block30;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int len = inputStream.read(buffer);
            while (len != -1) {
                outputStream.write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
            bl = true;
            if (outputStream == null) break block31;
            try {
                outputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable t) {
            try {
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public static int getConsoleMode() {
        try {
            Class.forName("java.io.Console");
            return System.console() != null ? 1 : 0;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static void main(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        if (!(args.length > 0 && "console".equalsIgnoreCase(args[args.length - 1]) || GraphicsEnvironment.isHeadless())) {
            FrameOcrSample.main(args);
            return;
        }
        String copyright = "Copyright Asprise, " + Calendar.getInstance().get(1) + ". All Rights Reserved. Visit www.asprise.com";
        String version = "Library version: " + Ocr.getLibraryVersion();
        int consoleMode = Ocr.getConsoleMode();
        if (consoleMode != 1) {
            JOptionPane.showMessageDialog(null, version, copyright, 1);
        }
        if (consoleMode != 0 || args.length > 0) {
            try {
                System.out.println(copyright);
                System.out.println(version);
                System.out.println(Utils.getEnvInfo(false));
                Ocr.setUp();
                System.out.println("Languages supported: " + Arrays.toString(Ocr.listSupportedLanguages()));
                String outputFormat = "text";
                if (args.length >= 2 && args[1] != null) {
                    if ("xml".equalsIgnoreCase(args[1].trim())) {
                        outputFormat = "xml";
                    } else if (OUTPUT_FORMAT_PDF.equalsIgnoreCase(args[1].trim())) {
                        outputFormat = OUTPUT_FORMAT_PDF;
                    } else if (!"text".equalsIgnoreCase(args[1].trim())) {
                        System.out.println("Invalid output format: " + args[1] + ", will use plain text instead. ");
                    }
                }
                String recognizeType = RECOGNIZE_TYPE_ALL;
                if (args.length >= 3 && args[2] != null) {
                    if (RECOGNIZE_TYPE_BARCODE.equalsIgnoreCase(args[2].trim())) {
                        recognizeType = RECOGNIZE_TYPE_ALL;
                    } else if ("text".equalsIgnoreCase(args[2].trim())) {
                        recognizeType = "text";
                    } else if (!RECOGNIZE_TYPE_ALL.equalsIgnoreCase(args[2].trim())) {
                        System.out.println("Invalid recognize type: " + args[2] + ", will use all instead. ");
                    }
                }
                String lang = LANGUAGE_ENG;
                if (args.length >= 4 && args[3] != null) {
                    lang = args[3].trim();
                }
                Object[] langs = Ocr.listSupportedLanguages();
                Arrays.sort(langs);
                if (Arrays.binarySearch(langs, lang) < 0) {
                    throw new IllegalArgumentException("'" + lang + "' is not in supported language list: " + Arrays.toString(langs));
                }
                if (args.length == 0) {
                    String usage = "Usage: java -jar aocr.jar INPUT_FILE [text|xml|pdf] [all|text|barcode] [eng|fra|micr|...]";
                    System.out.println(usage);
                } else {
                    File inputFile = new File(args[0]);
                    if (!inputFile.exists() && inputFile.isFile()) {
                        throw new IOException("File does not exist or unable to read: " + inputFile.getAbsolutePath());
                    }
                    int lastDot = inputFile.getName().lastIndexOf(46);
                    File pdfOutputFile = null;
                    Ocr.setUp();
                    Ocr ocr = new Ocr();
                    ocr.startEngine(lang, SPEED_FASTEST, new Object[0]);
                    long timeStart = System.currentTimeMillis();
                    Properties props = new Properties();
                    if (outputFormat == OUTPUT_FORMAT_PDF) {
                        pdfOutputFile = new File("output-" + inputFile.getName() + "-" + System.currentTimeMillis() + ".pdf");
                        props.put(PROP_PDF_OUTPUT_FILE, pdfOutputFile.getAbsolutePath());
                        props.put(PROP_PDF_OUTPUT_TEXT_VISIBLE, (Object)true);
                    }
                    if (Utils.isLaptop() == 1) {
                        System.out.println("NOTICE: You are using a portable computer. It could result long execution time due to low processor power.");
                    }
                    System.out.println("OCR in progress, please stand by ...");
                    String s = null;
                    s = ocr.recognize(new File[]{inputFile}, recognizeType, outputFormat, props);
                    long timeTaken = System.currentTimeMillis() - timeStart;
                    ocr.stopEngine();
                    System.out.println("--- RESULT ---");
                    if (pdfOutputFile != null) {
                        System.out.println("PDF output has been written to the following file: \n" + pdfOutputFile.getAbsolutePath());
                        System.out.println("For illustration purpose, text has been rendered in color instead of transparent.");
                        if (pdfOutputFile.exists() && pdfOutputFile.length() > 0L && Utils.isWindows()) {
                            try {
                                Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + pdfOutputFile.getAbsolutePath());
                            }
                            catch (Throwable t) {}
                        }
                    } else {
                        System.out.println(s);
                    }
                    System.out.println("--- Time taken (excluding engine startup time): " + (double)timeTaken / 1000.0 + "s ---");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        OcrLibHelper.loadOcrLib();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImagePreProcessingType {
        DEFAULT,
        DEFAULT_WITH_ORIENTATION_DETECTION,
        CUSTOM;


        public String toString() {
            switch (this) {
                case DEFAULT: {
                    return Ocr.PROP_IMG_PREPROCESS_TYPE_DEFAULT;
                }
                case DEFAULT_WITH_ORIENTATION_DETECTION: {
                    return Ocr.PROP_IMG_PREPROCESS_TYPE_DEFAULT_WITH_ORIENTATION_DETECTION;
                }
                case CUSTOM: {
                    return Ocr.PROP_IMG_PREPROCESS_TYPE_CUSTOM;
                }
            }
            return "!unknown";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageType {
        AUTO,
        SINGLE_BLOCK,
        SINGLE_COLUMN,
        SINGLE_LINE,
        SINGLE_WORD,
        SINGLE_CHAR,
        SCATTERED;


        public String toString() {
            switch (this) {
                case AUTO: {
                    return Ocr.PROP_PAGE_TYPE_AUTO;
                }
                case SINGLE_BLOCK: {
                    return Ocr.PROP_PAGE_TYPE_SINGLE_BLOCK;
                }
                case SINGLE_COLUMN: {
                    return Ocr.PROP_PAGE_TYPE_SINGLE_COLUMN;
                }
                case SINGLE_LINE: {
                    return Ocr.PROP_PAGE_TYPE_SINGLE_LINE;
                }
                case SINGLE_WORD: {
                    return Ocr.PROP_PAGE_TYPE_SINGLE_WORD;
                }
                case SINGLE_CHAR: {
                    return Ocr.PROP_PAGE_TYPE_SINGLE_CHAR;
                }
                case SCATTERED: {
                    return Ocr.PROP_PAGE_TYPE_SCATTERED;
                }
            }
            return "!unknown";
        }

        public static PageType parse(String s) {
            if (Ocr.PROP_PAGE_TYPE_AUTO.equals(s)) {
                return AUTO;
            }
            if (Ocr.PROP_PAGE_TYPE_SINGLE_BLOCK.equals(s)) {
                return SINGLE_BLOCK;
            }
            if (Ocr.PROP_PAGE_TYPE_SINGLE_COLUMN.equals(s)) {
                return SINGLE_COLUMN;
            }
            if (Ocr.PROP_PAGE_TYPE_SINGLE_LINE.equals(s)) {
                return SINGLE_LINE;
            }
            if (Ocr.PROP_PAGE_TYPE_SINGLE_WORD.equals(s)) {
                return SINGLE_WORD;
            }
            if (Ocr.PROP_PAGE_TYPE_SINGLE_CHAR.equals(s)) {
                return SINGLE_CHAR;
            }
            if (Ocr.PROP_PAGE_TYPE_SCATTERED.equals(s)) {
                return SCATTERED;
            }
            throw new UnsupportedOperationException(s);
        }
    }

    public static class PropertyBuilder
    extends Properties {
        public PropertyBuilder setDictSkipBuiltInDefault(boolean skip) {
            this.setProperty(Ocr.START_PROP_DICT_SKIP_BUILT_IN_DEFAULT, skip ? "true" : "false");
            return this;
        }

        public PropertyBuilder setDictSkipBuiltInAll(boolean skip) {
            this.setProperty(Ocr.START_PROP_DICT_SKIP_BUILT_IN_ALL, skip ? "true" : "false");
            return this;
        }

        public PropertyBuilder setDictCustomDictFile(File customDictFile) {
            if (customDictFile == null) {
                this.remove(Ocr.START_PROP_DICT_CUSTOM_DICT_FILE);
            } else {
                this.setProperty(Ocr.START_PROP_DICT_CUSTOM_DICT_FILE, customDictFile.getAbsolutePath());
            }
            return this;
        }

        public PropertyBuilder setDictCustomTemplatesFile(File customTemplatesFile) {
            if (customTemplatesFile == null) {
                this.remove(Ocr.START_PROP_DICT_CUSTOM_TEMPLATES_FILE);
            } else {
                this.setProperty(Ocr.START_PROP_DICT_CUSTOM_TEMPLATES_FILE, customTemplatesFile.getAbsolutePath());
            }
            return this;
        }

        public PropertyBuilder setDictImportance(int importance) {
            this.setProperty(Ocr.PROP_DICT_DICT_IMPORTANCE, Integer.toString(importance));
            return this;
        }

        public PropertyBuilder setPageType(PageType pageType) {
            this.setProperty(Ocr.PROP_PAGE_TYPE, pageType.toString());
            return this;
        }

        public PropertyBuilder setPageType(String pageType) {
            PageType type = PageType.parse(pageType);
            if (type == null) {
                throw new IllegalArgumentException();
            }
            this.setPageType(type);
            return this;
        }

        public PropertyBuilder setLimitToCharset(String chars) {
            this.setProperty(Ocr.PROP_LIMIT_TO_CHARSET, chars);
            return this;
        }

        public PropertyBuilder setLimitToCharsetDigitsOnly() {
            this.setLimitToCharset("0123456789");
            return this;
        }

        public PropertyBuilder setOutputSeparateWords(boolean enable) {
            this.setProperty(Ocr.PROP_OUTPUT_SEPARATE_WORDS, String.valueOf(enable));
            return this;
        }

        public PropertyBuilder setInputPdfDpi(int dpi) {
            if (dpi <= 0) {
                throw new IllegalArgumentException("DPI must be greater than 0. Suggested values: 300, 350, 400.");
            }
            this.setProperty(Ocr.PROP_INPUT_PDF_DPI, String.valueOf(dpi));
            return this;
        }

        public PropertyBuilder setImagePreProcessingType(ImagePreProcessingType type) {
            this.setProperty(Ocr.PROP_IMG_PREPROCESS_TYPE, type.toString());
            return this;
        }

        public PropertyBuilder setCustomImagePreProcessing(String cmds) {
            this.setImagePreProcessingType(ImagePreProcessingType.CUSTOM);
            this.setProperty(Ocr.PROP_IMG_PREPROCESS_CUSTOM_CMDS, cmds == null ? "" : cmds);
            return this;
        }

        public PropertyBuilder setSkipTableDetection(boolean skipTableDetection) {
            this.setProperty(Ocr.PROP_TABLE_SKIP_DETECTION, String.valueOf(skipTableDetection));
            return this;
        }

        public PropertyBuilder setTableDetectionMinSideLength(int minSideLength) {
            this.setProperty(Ocr.PROP_TABLE_MIN_SIDE_LENGTH, String.valueOf(minSideLength));
            return this;
        }

        public PropertyBuilder saveIntermediateImagesToDir(File dir) {
            this.setProperty(Ocr.PROP_SAVE_INTERMEDIATE_IMAGES_TO_DIR, dir == null ? "" : dir.toString());
            return this;
        }

        public PropertyBuilder setPdfOutputFile(File file) {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_FILE, file.getAbsolutePath());
            return this;
        }

        public PropertyBuilder setPdfOutputFile(String filePath) {
            return this.setPdfOutputFile(new File(filePath));
        }

        public PropertyBuilder setPdfOutputFontSans(boolean enable) {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_FONT, enable ? "sans" : "");
            return this;
        }

        public PropertyBuilder setPdfTextVisible(boolean enable) {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_TEXT_VISIBLE, String.valueOf(enable));
            return this;
        }

        public PropertyBuilder setPdfImageForceBlackWhite(boolean enable) {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_IMAGE_FORCE_BW, String.valueOf(enable));
            return this;
        }

        public PropertyBuilder setPdfOutputReturnPlainText() {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_RETURN_TEXT, "text");
            return this;
        }

        public PropertyBuilder setPdfOutputReturnXml() {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_RETURN_TEXT, "xml");
            return this;
        }

        public PropertyBuilder setPdfOutputReturnNothing() {
            this.remove(Ocr.PROP_PDF_OUTPUT_RETURN_TEXT);
            return this;
        }

        public PropertyBuilder setPdfOutputPdfa(boolean enable) {
            this.setProperty(Ocr.PROP_PDF_OUTPUT_PDFA, String.valueOf(enable));
            return this;
        }

        public PropertyBuilder setPdfaFontFile(File file) {
            if (file == null) {
                this.remove(Ocr.PROP_PDF_OUTPUT_PDFA_FONT_FILE);
            } else {
                this.setProperty(Ocr.PROP_PDF_OUTPUT_PDFA_FONT_FILE, file.getAbsolutePath());
            }
            return this;
        }

        public PropertyBuilder setRtfOutputFile(File file) {
            this.setProperty(Ocr.PROP_RTF_OUTPUT_FILE, file.getAbsolutePath());
            return this;
        }

        public PropertyBuilder setRtfOutputReturnPlainText() {
            this.setProperty(Ocr.PROP_RTF_OUTPUT_RETURN_TEXT, "text");
            return this;
        }

        public PropertyBuilder setRtfOutputReturnXml() {
            this.setProperty(Ocr.PROP_RTF_OUTPUT_RETURN_TEXT, "xml");
            return this;
        }

        public PropertyBuilder setRtfOutputReturnNothing() {
            this.remove(Ocr.PROP_RTF_OUTPUT_RETURN_TEXT);
            return this;
        }
    }
}

