/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.PBE;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class PBESecretKeyFactory
extends BaseSecretKeyFactory
implements PBE {
    private boolean a;
    private int b;
    private int c;
    private int d;
    private int e;

    public PBESecretKeyFactory(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, int n2, int n3, int n4, int n5) {
        super(string, aSN1ObjectIdentifier);
        this.a = bl2;
        this.b = n2;
        this.c = n3;
        this.d = n4;
        this.e = n5;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
            if (pBEKeySpec.getSalt() == null) {
                return new BCPBEKey(this.algName, this.algOid, this.b, this.c, this.d, this.e, pBEKeySpec, null);
            }
            CipherParameters cipherParameters = this.a ? PBE.Util.makePBEParameters(pBEKeySpec, this.b, this.c, this.d, this.e) : PBE.Util.makePBEMacParameters(pBEKeySpec, this.b, this.c, this.d);
            return new BCPBEKey(this.algName, this.algOid, this.b, this.c, this.d, this.e, pBEKeySpec, cipherParameters);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

