/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import com.aspose.cad.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.engines.CryptoProWrapEngine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.GOST28147Engine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.GOST28147WrapEngine;
import com.aspose.cad.internal.bouncycastle.crypto.macs.GOST28147Mac;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;

public final class GOST28147 {
    private static Map<ASN1ObjectIdentifier, String> a = new HashMap<ASN1ObjectIdentifier, String>();
    private static Map<String, ASN1ObjectIdentifier> b = new HashMap<String, ASN1ObjectIdentifier>();

    private GOST28147() {
    }

    static {
        a.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_TestParamSet, "E-TEST");
        a.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet, "E-A");
        a.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet, "E-B");
        a.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet, "E-C");
        a.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet, "E-D");
        b.put("E-A", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet);
        b.put("E-B", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet);
        b.put("E-C", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet);
        b.put("E-D", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet);
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        byte[] iv = new byte[8];
        byte[] sBox = GOST28147Engine.getSBox("E-A");

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof GOST28147ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter spec not supported");
            }
            this.sBox = ((GOST28147ParameterSpec)algorithmParameterSpec).getSBox();
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(this.iv);
            try {
                algorithmParameters = this.createParametersInstance("GOST28147");
                algorithmParameters.init(new GOST28147ParameterSpec(this.sBox, this.iv));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends BaseAlgParams {
        private ASN1ObjectIdentifier a = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        private byte[] b;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return new GOST28147Parameters(this.b, this.a).getEncoded();
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(this.b);
            }
            if (clazz == GOST28147ParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new GOST28147ParameterSpec(this.a, this.b);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.b = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                this.b = ((GOST28147ParameterSpec)algorithmParameterSpec).getIV();
                try {
                    this.a = AlgParams.getSBoxOID(((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidParameterSpecException(illegalArgumentException.getMessage());
                }
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(byArray);
            if (aSN1Primitive instanceof ASN1OctetString) {
                this.b = ASN1OctetString.getInstance(aSN1Primitive).getOctets();
            } else if (aSN1Primitive instanceof ASN1Sequence) {
                GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Primitive);
                this.a = gOST28147Parameters.getEncryptionParamSet();
                this.b = gOST28147Parameters.getIV();
            } else {
                throw new IOException("Unable to recognize parameters");
            }
        }

        @Override
        protected String engineToString() {
            return "GOST 28147 IV Parameters";
        }
    }

    public static abstract class BaseAlgParams
    extends BaseAlgorithmParameters {
        private ASN1ObjectIdentifier a = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        private byte[] b;

        @Override
        protected final void engineInit(byte[] byArray) throws IOException {
            this.engineInit(byArray, "ASN.1");
        }

        @Override
        protected final byte[] engineGetEncoded() throws IOException {
            return this.engineGetEncoded("ASN.1");
        }

        @Override
        protected final byte[] engineGetEncoded(String string) throws IOException {
            if (this.isASN1FormatString(string)) {
                return this.localGetEncoded();
            }
            throw new IOException("Unknown parameter format: " + string);
        }

        @Override
        protected final void engineInit(byte[] byArray, String string) throws IOException {
            if (byArray == null) {
                throw new NullPointerException("Encoded parameters cannot be null");
            }
            if (this.isASN1FormatString(string)) {
                try {
                    this.localInit(byArray);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException("Parameter parsing failed: " + exception.getMessage());
                }
            } else {
                throw new IOException("Unknown parameter format: " + string);
            }
        }

        protected byte[] localGetEncoded() throws IOException {
            return new GOST28147Parameters(this.b, this.a).getEncoded();
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(this.b);
            }
            if (clazz == GOST28147ParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new GOST28147ParameterSpec(this.a, this.b);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.b = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                this.b = ((GOST28147ParameterSpec)algorithmParameterSpec).getIV();
                try {
                    this.a = BaseAlgParams.getSBoxOID(((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidParameterSpecException(illegalArgumentException.getMessage());
                }
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
        }

        protected static ASN1ObjectIdentifier getSBoxOID(String string) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)b.get(string);
            if (aSN1ObjectIdentifier == null) {
                throw new IllegalArgumentException("Unknown SBOX name: " + string);
            }
            return aSN1ObjectIdentifier;
        }

        protected static ASN1ObjectIdentifier getSBoxOID(byte[] byArray) {
            return BaseAlgParams.getSBoxOID(GOST28147Engine.getSBoxName(byArray));
        }

        abstract void localInit(byte[] var1) throws IOException;
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new GOST28147Engine()), 64);
        }
    }

    public static class CryptoProWrap
    extends BaseWrapCipher {
        public CryptoProWrap() {
            super(new CryptoProWrapEngine());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST28147Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new GCFBBlockCipher(new GOST28147Engine())), 64);
        }
    }

    public static class GostWrap
    extends BaseWrapCipher {
        public GostWrap() {
            super(new GOST28147WrapEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int n2) {
            super("GOST28147", n2, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new GOST28147Mac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String a = GOST28147.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.GOST28147", a + "$ECB");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.GOST", "GOST28147");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.GOST-28147", "GOST28147");
            configurableProvider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.gostR28147_gcfb, a + "$GCFB");
            configurableProvider.addAlgorithm("KeyGenerator.GOST28147", a + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.GOST", "GOST28147");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_gcfb, "GOST28147");
            configurableProvider.addAlgorithm("AlgorithmParameters.GOST28147", a + "$AlgParams");
            configurableProvider.addAlgorithm("AlgorithmParameterGenerator.GOST28147", a + "$AlgParamGen");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + CryptoProObjectIdentifiers.gostR28147_gcfb, "GOST28147");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + CryptoProObjectIdentifiers.gostR28147_gcfb, "GOST28147");
            configurableProvider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap, a + "$CryptoProWrap");
            configurableProvider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap, a + "$GostWrap");
            configurableProvider.addAlgorithm("Mac.GOST28147MAC", a + "$Mac");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        }
    }
}

