/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145ECBinary;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145Params;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.aspose.cad.internal.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.ECPublicKey;
import com.aspose.cad.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECPublicKeySpec;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class BCDSTU4145PublicKey
implements ECPointEncoder,
ECPublicKey,
java.security.interfaces.ECPublicKey {
    static final long serialVersionUID = 7026240464295649314L;
    private String a = "DSTU4145";
    private boolean b;
    private transient ECPublicKeyParameters c;
    private transient ECParameterSpec d;
    private transient DSTU4145Params e;

    public BCDSTU4145PublicKey(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        this.c = bCDSTU4145PublicKey.c;
        this.d = bCDSTU4145PublicKey.d;
        this.b = bCDSTU4145PublicKey.b;
        this.e = bCDSTU4145PublicKey.e;
    }

    public BCDSTU4145PublicKey(java.security.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.d = eCPublicKeySpec.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKeySpec.getW(), false), EC5Util.getDomainParameters(null, this.d));
    }

    public BCDSTU4145PublicKey(ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.c = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
            this.d = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.c = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters(providerConfiguration, null));
            this.d = null;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            this.d = eCParameterSpec;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
        this.c = eCPublicKeyParameters;
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.a = string;
        this.c = eCPublicKeyParameters;
        this.d = null;
    }

    private ECParameterSpec a(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    BCDSTU4145PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a(subjectPublicKeyInfo);
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by2;
        }
    }

    private void a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        Object object2;
        ASN1OctetString aSN1OctetString;
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        this.a = "DSTU4145";
        try {
            aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] byArray = aSN1OctetString.getOctets();
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
            this.a(byArray);
        }
        this.e = DSTU4145Params.getInstance((ASN1Sequence)subjectPublicKeyInfo.getAlgorithm().getParameters());
        com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = null;
        if (this.e.isNamedCurve()) {
            object2 = this.e.getNamedCurve();
            object = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)object2);
            eCParameterSpec = new ECNamedCurveParameterSpec(((ASN1ObjectIdentifier)object2).getId(), ((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getG(), ((ECDomainParameters)object).getN(), ((ECDomainParameters)object).getH(), ((ECDomainParameters)object).getSeed());
        } else {
            object2 = this.e.getECBinary();
            object = ((DSTU4145ECBinary)object2).getB();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                this.a((byte[])object);
            }
            DSTU4145BinaryField dSTU4145BinaryField = ((DSTU4145ECBinary)object2).getField();
            ECCurve.F2m f2m = new ECCurve.F2m(dSTU4145BinaryField.getM(), dSTU4145BinaryField.getK1(), dSTU4145BinaryField.getK2(), dSTU4145BinaryField.getK3(), ((DSTU4145ECBinary)object2).getA(), new BigInteger(1, (byte[])object));
            byte[] byArray2 = ((DSTU4145ECBinary)object2).getG();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                this.a(byArray2);
            }
            eCParameterSpec = new com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec(f2m, DSTU4145PointEncoder.decodePoint(f2m, byArray2), ((DSTU4145ECBinary)object2).getN());
        }
        object2 = eCParameterSpec.getCurve();
        object = EC5Util.convertCurve((ECCurve)object2, eCParameterSpec.getSeed());
        this.d = this.e.isNamedCurve() ? new ECNamedCurveSpec(this.e.getNamedCurve().getId(), (EllipticCurve)object, EC5Util.convertPoint(eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH()) : new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint(eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        this.c = new ECPublicKeyParameters(DSTU4145PointEncoder.decodePoint((ECCurve)object2, byArray), EC5Util.getDomainParameters(null, this.d));
    }

    public byte[] getSbox() {
        if (null != this.e) {
            return this.e.getDKE();
        }
        return DSTU4145Params.getDefaultDKE();
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Object object;
        ASN1Object aSN1Object;
        if (this.e != null) {
            aSN1Object = this.e;
        } else if (this.d instanceof ECNamedCurveSpec) {
            aSN1Object = new DSTU4145Params(new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.d).getName()));
        } else {
            object = EC5Util.convertCurve(this.d.getCurve());
            X9ECParameters x9ECParameters = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.d.getGenerator(), this.b), this.d.getOrder(), BigInteger.valueOf(this.d.getCofactor()), this.d.getCurve().getSeed());
            aSN1Object = new X962Parameters(x9ECParameters);
        }
        object = DSTU4145PointEncoder.encodePoint(this.c.getQ());
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, aSN1Object), new DEROctetString((byte[])object));
        }
        catch (IOException iOException) {
            return null;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    @Override
    public ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    @Override
    public java.security.spec.ECPoint getW() {
        return EC5Util.convertPoint(this.c.getQ());
    }

    @Override
    public ECPoint getQ() {
        ECPoint eCPoint = this.c.getQ();
        if (this.d == null) {
            return eCPoint.getDetachedPoint();
        }
        return eCPoint;
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.c;
    }

    com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString(this.a, this.c.getQ(), this.engineGetSpec());
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PublicKey)) {
            return false;
        }
        BCDSTU4145PublicKey bCDSTU4145PublicKey = (BCDSTU4145PublicKey)object;
        return this.c.getQ().equals(bCDSTU4145PublicKey.c.getQ()) && this.engineGetSpec().equals(bCDSTU4145PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.c.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

