/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dh;

import com.aspose.cad.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.cad.internal.bouncycastle.crypto.agreement.kdf.DHKEKGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;

    public KeyAgreementSpi() {
        super("Diffie-Hellman", null);
    }

    public KeyAgreementSpi(String string, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
    }

    protected byte[] bigIntToBytes(BigInteger bigInteger) {
        int n2 = (this.d.bitLength() + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n2) {
            return byArray;
        }
        if (byArray[0] == 0 && byArray.length == n2 + 1) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
        return byArray3;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (this.c == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("DHKeyAgreement doPhase requires DHPublicKey");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        if (!dHPublicKey.getParams().getG().equals(this.e) || !dHPublicKey.getParams().getP().equals(this.d)) {
            throw new InvalidKeyException("DHPublicKey not for this KeyAgreement!");
        }
        BigInteger bigInteger = ((DHPublicKey)key).getY();
        if (bigInteger == null || bigInteger.compareTo(b) < 0 || bigInteger.compareTo(this.d.subtract(a)) >= 0) {
            throw new InvalidKeyException("Invalid DH PublicKey");
        }
        this.f = bigInteger.modPow(this.c, this.d);
        if (this.f.compareTo(a) == 0) {
            throw new InvalidKeyException("Shared key can't be 1");
        }
        if (bl2) {
            return null;
        }
        return new BCDHPublicKey(this.f, dHPublicKey.getParams());
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.c == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        return super.engineGenerateSecret();
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (this.c == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        return super.engineGenerateSecret(byArray, n2);
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        if (this.c == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        byte[] byArray = this.bigIntToBytes(this.f);
        if (string.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(KeyAgreementSpi.trimZeroes(byArray), string);
        }
        return super.engineGenerateSecret(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey for initialisation");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof DHParameterSpec) {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                this.d = dHParameterSpec.getP();
                this.e = dHParameterSpec.getG();
            } else {
                if (!(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) throw new InvalidAlgorithmParameterException("DHKeyAgreement only accepts DHParameterSpec");
                this.d = dHPrivateKey.getParams().getP();
                this.e = dHPrivateKey.getParams().getG();
                this.ukmParameters = ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial();
            }
        } else {
            this.d = dHPrivateKey.getParams().getP();
            this.e = dHPrivateKey.getParams().getG();
        }
        this.c = this.f = dHPrivateKey.getX();
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        this.d = dHPrivateKey.getParams().getP();
        this.e = dHPrivateKey.getParams().getG();
        this.c = this.f = dHPrivateKey.getX();
    }

    @Override
    protected byte[] calcSecret() {
        return this.bigIntToBytes(this.f);
    }

    public static class DHwithRFC2631KDF
    extends KeyAgreementSpi {
        public DHwithRFC2631KDF() {
            super("DHwithRFC2631KDF", new DHKEKGenerator(DigestFactory.createSHA1()));
        }
    }
}

