/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.Signer;
import com.aspose.cad.internal.bouncycastle.crypto.params.DHParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.DigitallySigned;
import com.aspose.cad.internal.bouncycastle.crypto.tls.SecurityParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.ServerDHParams;
import com.aspose.cad.internal.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsCredentials;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsDHUtils;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSigner;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.cad.internal.bouncycastle.crypto.tls.k;
import com.aspose.cad.internal.bouncycastle.crypto.tls.o;
import com.aspose.cad.internal.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int n2, Vector vector, DHParameters dHParameters) {
        super(n2, vector, dHParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        k k2 = new k();
        this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, k2);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest digest = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        k2.a(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode(k2);
        return k2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        o o2 = new o();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, o2);
        ServerDHParams serverDHParams = ServerDHParams.parse(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(inputStream);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        o2.a(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreePublicKey = TlsDHUtils.validateDHPublicKey(serverDHParams.getPublicKey());
        this.dhParameters = this.validateDHParameters(this.dhAgreePublicKey.getParameters());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

